/*
 * Decompiled with CFR 0.152.
 */
package de.redgames.f3nperm;

import de.redgames.f3nperm.F3NPermPlugin;
import de.redgames.f3nperm.OpPermissionLevel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Settings {
    private final boolean useProtocolLib;
    private final OpPermissionLevel opPermissionLevel;
    private final boolean enablePermissionCheck;
    private final Set<String> hooks;

    public static Settings loadSettings(F3NPermPlugin plugin, Path dataFolder) throws IOException {
        InputStream config;
        Path configFile = dataFolder.resolve("config.yml");
        if (!Files.isRegularFile(configFile, new LinkOption[0])) {
            config = plugin.getResource("config.yml");
            Throwable throwable = null;
            try {
                if (config == null) {
                    throw new IOException("Default configuration was not found in jar!");
                }
                Files.createDirectories(dataFolder, new FileAttribute[0]);
                Files.copy(config, configFile, new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (config != null) {
                    if (throwable != null) {
                        try {
                            config.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        config.close();
                    }
                }
            }
        }
        config = YamlConfiguration.loadConfiguration((File)configFile.toFile());
        return new Settings((FileConfiguration)config);
    }

    private Settings(FileConfiguration config) throws IOException {
        this.useProtocolLib = config.getBoolean("use-protocol-lib", true);
        int opPermissionLevelInt = config.getInt("op-permission-level", OpPermissionLevel.ADMIN_COMMANDS.getLevel());
        this.opPermissionLevel = OpPermissionLevel.fromLevel(opPermissionLevelInt);
        if (this.opPermissionLevel == null) {
            throw new IOException("OpPermissionLevel " + opPermissionLevelInt + " is not recognized!");
        }
        this.enablePermissionCheck = config.getBoolean("enable-permission-check", false);
        this.hooks = new HashSet<String>();
        this.hooks.addAll(config.getStringList("hooks"));
    }

    public boolean isEnablePermissionCheck() {
        return this.enablePermissionCheck;
    }

    public OpPermissionLevel getOpPermissionLevel() {
        return this.opPermissionLevel;
    }

    public boolean isUseProtocolLib() {
        return this.useProtocolLib;
    }

    public Set<String> getHooks() {
        return this.hooks;
    }
}

