/*
 * Decompiled with CFR 0.152.
 */
package de.redgames.f3nperm;

public enum OpPermissionLevel {
    NO_PERMISSIONS(0),
    ACCESS_SPAWN(1),
    WORLD_COMMANDS(2),
    PLAYER_COMMANDS(3),
    ADMIN_COMMANDS(4);

    private final int level;
    private static final OpPermissionLevel[] values;

    private OpPermissionLevel(int level) {
        this.level = level;
    }

    public byte toStatusByte() {
        int baseOffset = 24;
        return (byte)(this.level + 24);
    }

    public int getLevel() {
        return this.level;
    }

    public static OpPermissionLevel fromLevel(int level) {
        for (OpPermissionLevel value : values) {
            if (value.getLevel() != level) continue;
            return value;
        }
        return null;
    }

    public static OpPermissionLevel fromStatusByte(byte statusByte) {
        for (OpPermissionLevel value : values) {
            if (value.toStatusByte() != statusByte) continue;
            return value;
        }
        return null;
    }

    static {
        values = OpPermissionLevel.values();
    }
}

