/*
 * Decompiled with CFR 0.152.
 */
package de.redgames.f3nperm;

import de.redgames.f3nperm.F3NPermCommand;
import de.redgames.f3nperm.F3NPermListener;
import de.redgames.f3nperm.NMSVersion;
import de.redgames.f3nperm.OpPermissionLevel;
import de.redgames.f3nperm.Settings;
import de.redgames.f3nperm.hooks.Hook;
import de.redgames.f3nperm.hooks.LuckPermsHook;
import de.redgames.f3nperm.provider.ProtocolLibProvider;
import de.redgames.f3nperm.provider.Provider;
import de.redgames.f3nperm.provider.ProviderException;
import de.redgames.f3nperm.provider.ReflectionProvider_v1_17_R1;
import de.redgames.f3nperm.provider.ReflectionProvider_v1_18_R1;
import de.redgames.f3nperm.provider.ReflectionProvider_v1_18_R2;
import de.redgames.f3nperm.provider.ReflectionProvider_v1_19_R1;
import de.redgames.f3nperm.provider.ReflectionProvider_v1_19_R3;
import de.redgames.f3nperm.provider.ReflectionProvider_v1_9_R1;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class F3NPermPlugin
extends JavaPlugin
implements Listener {
    private final Hook[] hooks = new Hook[]{new LuckPermsHook()};
    private Provider provider;
    private NMSVersion nmsVersion;
    private Settings settings;
    private List<Hook> registeredHooks;

    public void onLoad() {
        this.nmsVersion = NMSVersion.fromBukkitVersion();
        if (this.nmsVersion == null) {
            this.getLogger().warning("Could not read server version, proceed with caution!");
        } else {
            this.getLogger().info("Server version " + this.nmsVersion + " detected");
        }
        this.loadSettings();
        this.provider = this.findProvider();
        this.getLogger().info("Provider " + this.provider.getClass().getSimpleName() + " loaded!");
        this.getLogger().info("Plugin loaded!");
    }

    public void onEnable() {
        F3NPermCommand f3nPermCommand = new F3NPermCommand(this);
        this.getCommand("f3nperm").setExecutor((CommandExecutor)f3nPermCommand);
        this.getCommand("f3nperm").setTabCompleter((TabCompleter)f3nPermCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new F3NPermListener(this), (Plugin)this);
        try {
            this.provider.register(this);
        }
        catch (ProviderException e) {
            this.getLogger().log(Level.SEVERE, "Could not register provider " + this.provider.getClass().getSimpleName() + "!", e);
        }
        this.loadHooks();
        this.getLogger().info("Plugin enabled!");
    }

    public void onDisable() {
        if (this.registeredHooks != null) {
            for (Hook hook : this.registeredHooks) {
                hook.unregister(this);
            }
        }
        try {
            this.provider.unregister(this);
        }
        catch (ProviderException e) {
            this.getLogger().log(Level.SEVERE, "Could not unregister provider " + this.provider.getClass().getSimpleName() + "!", e);
        }
        this.getLogger().info("Plugin disabled!");
    }

    public void reloadPlugin() {
        for (Hook hook : this.registeredHooks) {
            hook.unregister(this);
        }
        this.loadSettings();
        this.loadHooks();
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.provider.update(player);
        }
    }

    private void loadSettings() {
        try {
            this.settings = Settings.loadSettings(this, this.getDataFolder().toPath());
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error loading configuration!", e);
            throw new RuntimeException();
        }
    }

    private void loadHooks() {
        this.registeredHooks = new ArrayList<Hook>();
        for (Hook hook : this.hooks) {
            if (!this.getSettings().getHooks().contains(hook.getName())) continue;
            hook.register(this);
            this.registeredHooks.add(hook);
        }
    }

    private Provider findProvider() {
        if (this.getServer().getPluginManager().getPlugin("ProtocolLib") != null && this.settings.isUseProtocolLib()) {
            return new ProtocolLibProvider();
        }
        if (this.nmsVersion == null) {
            throw new ProviderException("Server version cannot be detected and ProtocolLib is disabled!");
        }
        if (this.nmsVersion.isLowerThan(NMSVersion.v1_17_R1)) {
            return new ReflectionProvider_v1_9_R1();
        }
        if (this.nmsVersion.isLowerThan(NMSVersion.v1_18_R1)) {
            return new ReflectionProvider_v1_17_R1();
        }
        if (this.nmsVersion.isLowerThan(NMSVersion.v1_18_R2)) {
            return new ReflectionProvider_v1_18_R1();
        }
        if (this.nmsVersion.isLowerThan(NMSVersion.v1_19_R1)) {
            return new ReflectionProvider_v1_18_R2();
        }
        if (this.nmsVersion.isLowerThan(NMSVersion.v1_19_R3)) {
            return new ReflectionProvider_v1_19_R1();
        }
        return new ReflectionProvider_v1_19_R3();
    }

    public OpPermissionLevel getF3NPermPermissionLevel(Player player) {
        if (!this.settings.isEnablePermissionCheck() || player.hasPermission("f3nperm.use") || player.hasPermission("F3NPerm.use") || player.isOp()) {
            return this.settings.getOpPermissionLevel();
        }
        return OpPermissionLevel.NO_PERMISSIONS;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public Settings getSettings() {
        return this.settings;
    }
}

