/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.utils;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.plugin.java.JavaPlugin;

public class Updater {
    private JavaPlugin plugin;
    private final String API_KEY = "98BE0FE67F88AB82B4C197FAF1DC3B69206EFDCC4D3B80FC83A00037510B99B4";
    private final String REQUEST_METHOD = "GET";
    private String RESOURCE_ID = "";
    private final String HOST = "https://api.spigotmc.org/legacy";
    private final String QUERY = "/update.php";
    private String WRITE_STRING;
    private String version;
    private String oldVersion;
    private UpdateResult result = UpdateResult.DISABLED;
    private HttpURLConnection connection;
    private final String USER_AGENT = "Mozilla/5.0";

    public Updater(JavaPlugin plugin, Integer resourceId, boolean disabled) {
        this.RESOURCE_ID = "" + resourceId;
        this.plugin = plugin;
        this.oldVersion = this.plugin.getDescription().getVersion();
        if (disabled) {
            this.result = UpdateResult.DISABLED;
            return;
        }
        try {
            this.connection = (HttpURLConnection)new URL("https://api.spigotmc.org/legacy/update.php").openConnection();
        }
        catch (IOException e) {
            this.result = UpdateResult.FAIL_SPIGOT;
            return;
        }
        this.WRITE_STRING = "key=98BE0FE67F88AB82B4C197FAF1DC3B69206EFDCC4D3B80FC83A00037510B99B4&resource=" + this.RESOURCE_ID;
        try {
            this.sendGet();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void run() {
        String version;
        this.connection.setDoOutput(true);
        try {
            this.connection.setRequestMethod("GET");
            this.connection.getOutputStream().write(this.WRITE_STRING.getBytes("UTF-8"));
        }
        catch (ProtocolException e1) {
            this.result = UpdateResult.FAIL_SPIGOT;
        }
        catch (UnsupportedEncodingException e) {
            this.result = UpdateResult.FAIL_SPIGOT;
        }
        catch (IOException e) {
            this.result = UpdateResult.FAIL_SPIGOT;
        }
        try {
            version = new BufferedReader(new InputStreamReader(this.connection.getInputStream())).readLine();
        }
        catch (Exception e) {
            this.result = UpdateResult.BAD_RESOURCEID;
            e.printStackTrace();
            return;
        }
        if (version.length() <= 7) {
            this.version = version;
            version.replace("[^A-Za-z]", "").replace("|", "");
            this.versionCheck();
            return;
        }
        this.result = UpdateResult.BAD_RESOURCEID;
    }

    private void versionCheck() {
        this.result = this.shouldUpdate(this.oldVersion, this.version) ? UpdateResult.UPDATE_AVAILABLE : UpdateResult.NO_UPDATE;
    }

    public boolean shouldUpdate(String localVersion, String remoteVersion) {
        return Updater.isUpdateOut(remoteVersion, localVersion);
    }

    private static int[] getVersionNumbers(String ver) {
        Matcher m = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(beta(\\d*))?").matcher(ver);
        if (!m.matches()) {
            throw new IllegalArgumentException("Plugin version formatted wrong!");
        }
        return new int[]{Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), m.group(4) == null ? Integer.MAX_VALUE : (m.group(5).isEmpty() ? 1 : Integer.parseInt(m.group(5)))};
    }

    private static boolean isUpdateOut(String remote, String local) {
        int[] testVer = Updater.getVersionNumbers(remote);
        int[] baseVer = Updater.getVersionNumbers(local);
        int i = 0;
        while (i < testVer.length) {
            if (testVer[i] != baseVer[i]) {
                return testVer[i] > baseVer[i];
            }
            ++i;
        }
        return false;
    }

    public UpdateResult getResult() {
        return this.result;
    }

    public String getVersion() {
        return this.version;
    }

    private void sendGet() throws Exception {
        String inputLine;
        String url = "https://api.spigotmc.org/legacy/update.php?resource=" + this.RESOURCE_ID;
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("User-Agent", "Mozilla/5.0");
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        String version = response.toString();
        if (version.length() <= 7) {
            this.version = version;
            version.replace("[^A-Za-z]", "").replace("|", "");
            this.versionCheck();
            return;
        }
        this.result = UpdateResult.BAD_RESOURCEID;
    }

    private void sendPost() throws Exception {
        String inputLine;
        String url = "https://selfsolve.apple.com/wcResults.do";
        URL obj = new URL(url);
        HttpsURLConnection con = (HttpsURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("User-Agent", "Mozilla/5.0");
        con.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        String urlParameters = "sn=C02G8416DRJM&cn=&locale=&caller=&num=12345";
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(urlParameters);
        wr.flush();
        wr.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        System.out.println(response.toString());
    }

    public static enum UpdateResult {
        NO_UPDATE,
        DISABLED,
        FAIL_SPIGOT,
        FAIL_NOVERSION,
        BAD_RESOURCEID,
        UPDATE_AVAILABLE;

    }
}

