/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.utils;

import com.nefilto.gravy.Core;
import de.tr7zw.nbtapi.NBTItem;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TokenUtil {
    private Core plugin;

    public TokenUtil(Core plugin) {
        this.plugin = plugin;
    }

    public ItemStack makeToken() {
        ItemStack item = new ItemStack(Material.valueOf((String)this.plugin.getConfig().getString("token_item")), 1);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.plugin.getMsgsUtil().listToString(this.plugin.getMsgsUtil().getMsg("token_item_name")));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        meta.setLore(this.plugin.getMsgsUtil().getMsg("token_lore"));
        meta.setUnbreakable(true);
        item.setItemMeta(meta);
        item.addUnsafeEnchantment(Enchantment.LUCK, 1);
        NBTItem nbti = new NBTItem(item);
        nbti.setBoolean("isToken", Boolean.valueOf(true));
        nbti.setBoolean("Unbreakable", Boolean.valueOf(true));
        return nbti.getItem();
    }

    public boolean isToken(ItemStack item) {
        boolean result = false;
        if (item != null && !item.getType().equals((Object)Material.AIR)) {
            NBTItem nbtItem = new NBTItem(item);
            try {
                if (nbtItem.hasKey("isToken").booleanValue()) {
                    result = true;
                }
            }
            catch (Exception e) {
                return result;
            }
        }
        return result;
    }

    public boolean containToken(List<ItemStack> items) {
        boolean found = false;
        for (ItemStack item : items) {
            if (item == null || !this.isToken(item)) continue;
            found = true;
        }
        return found;
    }
}

