/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.libs.org.apache.commons.codec.binary.Base64;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public final class NBTEditor {
    private static final Map<String, Class<?>> classCache;
    private static final Map<String, Method> methodCache;
    private static final Map<Class<?>, Constructor<?>> constructorCache;
    private static final Map<Class<?>, Class<?>> NBTClasses;
    private static final Map<Class<?>, Field> NBTTagFieldCache;
    private static Field NBTListData;
    private static Field NBTCompoundMap;
    private static final String VERSION;

    static {
        VERSION = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        classCache = new HashMap();
        try {
            classCache.put("NBTBase", Class.forName("net.minecraft.server." + VERSION + "." + "NBTBase"));
            classCache.put("NBTTagCompound", Class.forName("net.minecraft.server." + VERSION + "." + "NBTTagCompound"));
            classCache.put("NBTTagList", Class.forName("net.minecraft.server." + VERSION + "." + "NBTTagList"));
            classCache.put("NBTBase", Class.forName("net.minecraft.server." + VERSION + "." + "NBTBase"));
            classCache.put("ItemStack", Class.forName("net.minecraft.server." + VERSION + "." + "ItemStack"));
            classCache.put("CraftItemStack", Class.forName("org.bukkit.craftbukkit." + VERSION + ".inventory." + "CraftItemStack"));
            classCache.put("Entity", Class.forName("net.minecraft.server." + VERSION + "." + "Entity"));
            classCache.put("CraftEntity", Class.forName("org.bukkit.craftbukkit." + VERSION + ".entity." + "CraftEntity"));
            classCache.put("EntityLiving", Class.forName("net.minecraft.server." + VERSION + "." + "EntityLiving"));
            classCache.put("CraftWorld", Class.forName("org.bukkit.craftbukkit." + VERSION + "." + "CraftWorld"));
            classCache.put("CraftBlockState", Class.forName("org.bukkit.craftbukkit." + VERSION + ".block." + "CraftBlockState"));
            classCache.put("BlockPosition", Class.forName("net.minecraft.server." + VERSION + "." + "BlockPosition"));
            classCache.put("TileEntity", Class.forName("net.minecraft.server." + VERSION + "." + "TileEntity"));
            classCache.put("World", Class.forName("net.minecraft.server." + VERSION + "." + "World"));
            classCache.put("TileEntitySkull", Class.forName("net.minecraft.server." + VERSION + "." + "TileEntitySkull"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        NBTClasses = new HashMap();
        try {
            NBTClasses.put(Byte.class, Class.forName("net.minecraft.server." + VERSION + "." + "NBTTagByte"));
            NBTClasses.put(String.class, Class.forName("net.minecraft.server." + VERSION + "." + "NBTTagString"));
            NBTClasses.put(Double.class, Class.forName("net.minecraft.server." + VERSION + "." + "NBTTagDouble"));
            NBTClasses.put(Integer.class, Class.forName("net.minecraft.server." + VERSION + "." + "NBTTagInt"));
            NBTClasses.put(Long.class, Class.forName("net.minecraft.server." + VERSION + "." + "NBTTagLong"));
            NBTClasses.put(Short.class, Class.forName("net.minecraft.server." + VERSION + "." + "NBTTagShort"));
            NBTClasses.put(Float.class, Class.forName("net.minecraft.server." + VERSION + "." + "NBTTagFloat"));
            NBTClasses.put(Class.forName("[B"), Class.forName("net.minecraft.server." + VERSION + "." + "NBTTagByteArray"));
            NBTClasses.put(Class.forName("[I"), Class.forName("net.minecraft.server." + VERSION + "." + "NBTTagIntArray"));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        methodCache = new HashMap<String, Method>();
        try {
            methodCache.put("get", NBTEditor.getNMSClass("NBTTagCompound").getMethod("get", String.class));
            methodCache.put("set", NBTEditor.getNMSClass("NBTTagCompound").getMethod("set", String.class, NBTEditor.getNMSClass("NBTBase")));
            methodCache.put("hasKey", NBTEditor.getNMSClass("NBTTagCompound").getMethod("hasKey", String.class));
            methodCache.put("setIndex", NBTEditor.getNMSClass("NBTTagList").getMethod("a", Integer.TYPE, NBTEditor.getNMSClass("NBTBase")));
            if (VERSION.contains("1_14") || VERSION.contains("1_15")) {
                methodCache.put("getTypeId", NBTEditor.getNMSClass("NBTBase").getMethod("getTypeId", new Class[0]));
                methodCache.put("add", NBTEditor.getNMSClass("NBTTagList").getMethod("add", Integer.TYPE, NBTEditor.getNMSClass("NBTBase")));
            } else {
                methodCache.put("add", NBTEditor.getNMSClass("NBTTagList").getMethod("add", NBTEditor.getNMSClass("NBTBase")));
            }
            if (VERSION.contains("1_8")) {
                methodCache.put("listRemove", NBTEditor.getNMSClass("NBTTagList").getMethod("a", Integer.TYPE));
            } else {
                methodCache.put("listRemove", NBTEditor.getNMSClass("NBTTagList").getMethod("remove", Integer.TYPE));
            }
            methodCache.put("remove", NBTEditor.getNMSClass("NBTTagCompound").getMethod("remove", String.class));
            methodCache.put("hasTag", NBTEditor.getNMSClass("ItemStack").getMethod("hasTag", new Class[0]));
            methodCache.put("getTag", NBTEditor.getNMSClass("ItemStack").getMethod("getTag", new Class[0]));
            methodCache.put("setTag", NBTEditor.getNMSClass("ItemStack").getMethod("setTag", NBTEditor.getNMSClass("NBTTagCompound")));
            methodCache.put("asNMSCopy", NBTEditor.getNMSClass("CraftItemStack").getMethod("asNMSCopy", ItemStack.class));
            methodCache.put("asBukkitCopy", NBTEditor.getNMSClass("CraftItemStack").getMethod("asBukkitCopy", NBTEditor.getNMSClass("ItemStack")));
            methodCache.put("getEntityHandle", NBTEditor.getNMSClass("CraftEntity").getMethod("getHandle", new Class[0]));
            methodCache.put("getEntityTag", NBTEditor.getNMSClass("Entity").getMethod("c", NBTEditor.getNMSClass("NBTTagCompound")));
            methodCache.put("setEntityTag", NBTEditor.getNMSClass("Entity").getMethod("f", NBTEditor.getNMSClass("NBTTagCompound")));
            if (VERSION.contains("1_12") || VERSION.contains("1_13") || VERSION.contains("1_14") || VERSION.contains("1_15")) {
                methodCache.put("setTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("load", NBTEditor.getNMSClass("NBTTagCompound")));
            } else {
                methodCache.put("setTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("a", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            methodCache.put("getTileEntity", NBTEditor.getNMSClass("World").getMethod("getTileEntity", NBTEditor.getNMSClass("BlockPosition")));
            methodCache.put("getWorldHandle", NBTEditor.getNMSClass("CraftWorld").getMethod("getHandle", new Class[0]));
            methodCache.put("setGameProfile", NBTEditor.getNMSClass("TileEntitySkull").getMethod("setGameProfile", GameProfile.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            methodCache.put("getTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("save", NBTEditor.getNMSClass("NBTTagCompound")));
        }
        catch (NoSuchMethodException exception) {
            try {
                methodCache.put("getTileTag", NBTEditor.getNMSClass("TileEntity").getMethod("b", NBTEditor.getNMSClass("NBTTagCompound")));
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        constructorCache = new HashMap();
        try {
            constructorCache.put(NBTEditor.getNBTTag(Byte.class), NBTEditor.getNBTTag(Byte.class).getConstructor(Byte.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(String.class), NBTEditor.getNBTTag(String.class).getConstructor(String.class));
            constructorCache.put(NBTEditor.getNBTTag(Double.class), NBTEditor.getNBTTag(Double.class).getConstructor(Double.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Integer.class), NBTEditor.getNBTTag(Integer.class).getConstructor(Integer.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Long.class), NBTEditor.getNBTTag(Long.class).getConstructor(Long.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Float.class), NBTEditor.getNBTTag(Float.class).getConstructor(Float.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Short.class), NBTEditor.getNBTTag(Short.class).getConstructor(Short.TYPE));
            constructorCache.put(NBTEditor.getNBTTag(Class.forName("[B")), NBTEditor.getNBTTag(Class.forName("[B")).getConstructor(Class.forName("[B")));
            constructorCache.put(NBTEditor.getNBTTag(Class.forName("[I")), NBTEditor.getNBTTag(Class.forName("[I")).getConstructor(Class.forName("[I")));
            constructorCache.put(NBTEditor.getNMSClass("BlockPosition"), NBTEditor.getNMSClass("BlockPosition").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NBTTagFieldCache = new HashMap();
        try {
            for (Class<?> clazz : NBTClasses.values()) {
                Field data = clazz.getDeclaredField("data");
                data.setAccessible(true);
                NBTTagFieldCache.put(clazz, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            NBTListData = NBTEditor.getNMSClass("NBTTagList").getDeclaredField("list");
            NBTListData.setAccessible(true);
            NBTCompoundMap = NBTEditor.getNMSClass("NBTTagCompound").getDeclaredField("map");
            NBTCompoundMap.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Class<?> getNBTTag(Class<?> primitiveType) {
        if (NBTClasses.containsKey(primitiveType)) {
            return NBTClasses.get(primitiveType);
        }
        return primitiveType;
    }

    private static Object getNBTVar(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        try {
            if (NBTTagFieldCache.containsKey(clazz)) {
                return NBTTagFieldCache.get(clazz).get(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static Method getMethod(String name) {
        return methodCache.containsKey(name) ? methodCache.get(name) : null;
    }

    private static Constructor<?> getConstructor(Class<?> clazz) {
        return constructorCache.containsKey(clazz) ? constructorCache.get(clazz) : null;
    }

    private static Class<?> getNMSClass(String name) {
        if (classCache.containsKey(name)) {
            return classCache.get(name);
        }
        try {
            return Class.forName("net.minecraft.server." + VERSION + "." + name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getMatch(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static final String getVersion() {
        return VERSION;
    }

    public static final ItemStack getHead(String skinURL) {
        Material material = Material.getMaterial((String)"SKULL_ITEM");
        if (material == null) {
            material = Material.getMaterial((String)"PLAYER_HEAD");
        }
        ItemStack head = new ItemStack(material, 1, 3);
        if (skinURL == null || skinURL.isEmpty()) {
            return head;
        }
        ItemMeta headMeta = head.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        byte[] encodedData = Base64.encodeBase64((byte[])String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", skinURL).getBytes());
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
        Field profileField = null;
        try {
            profileField = headMeta.getClass().getDeclaredField("profile");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        profileField.setAccessible(true);
        try {
            profileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        head.setItemMeta(headMeta);
        return head;
    }

    public static final String getTexture(ItemStack head) {
        GameProfile profile;
        block6: {
            ItemMeta meta = head.getItemMeta();
            Field profileField = null;
            try {
                profileField = meta.getClass().getDeclaredField("profile");
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Item is not a player skull!");
            }
            profileField.setAccessible(true);
            profile = (GameProfile)profileField.get(meta);
            if (profile != null) break block6;
            return null;
        }
        try {
            for (Property prop : profile.getProperties().values()) {
                if (!prop.getName().equals("textures")) continue;
                String texture = new String(Base64.decodeBase64((String)prop.getValue()));
                return NBTEditor.getMatch(texture, "\\{\"url\":\"(.*?)\"\\}");
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final Object getItemTag(ItemStack item, Object ... keys) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = null;
            stack = NBTEditor.getMethod("asNMSCopy").invoke(null, item);
            Object tag = null;
            tag = NBTEditor.getMethod("hasTag").invoke(stack, new Object[0]).equals(true) ? NBTEditor.getMethod("getTag").invoke(stack, new Object[0]) : (Object)NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            return NBTEditor.getTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final NBTCompound getItemNBTTag(ItemStack item, Object ... keys) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = null;
            stack = NBTEditor.getMethod("asNMSCopy").invoke(null, item);
            Object tag = null;
            if (NBTEditor.getMethod("hasTag").invoke(stack, new Object[0]).equals(true)) {
                tag = NBTEditor.getMethod("getTag").invoke(stack, new Object[0]);
            } else {
                tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
                Object count = NBTEditor.getConstructor(NBTEditor.getNBTTag(Integer.class)).newInstance(item.getAmount());
                NBTEditor.getMethod("set").invoke(tag, "Count", count);
                Object id = NBTEditor.getConstructor(NBTEditor.getNBTTag(String.class)).newInstance(item.getType().name().toLowerCase());
                NBTEditor.getMethod("set").invoke(tag, "id", id);
            }
            return NBTEditor.getNBTTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final ItemStack setItemTag(ItemStack item, Object value, Object ... keys) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = NBTEditor.getMethod("asNMSCopy").invoke(null, item);
            Object tag = null;
            tag = NBTEditor.getMethod("hasTag").invoke(stack, new Object[0]).equals(true) ? NBTEditor.getMethod("getTag").invoke(stack, new Object[0]) : (Object)NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.setTag(tag, value, keys);
            NBTEditor.getMethod("setTag").invoke(stack, tag);
            return (ItemStack)NBTEditor.getMethod("asBukkitCopy").invoke(null, stack);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final ItemStack getItemFromTag(NBTCompound compound) {
        Object id;
        Object count;
        Object tag;
        block5: {
            if (compound == null) {
                return null;
            }
            try {
                tag = compound.tag;
                count = NBTEditor.getTag(tag, "Count");
                id = NBTEditor.getTag(tag, "id");
                if (count != null && id != null) break block5;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (count instanceof Byte && id instanceof String) {
            byte amount = (Byte)count;
            String material = (String)id;
            Material type = Material.valueOf((String)material.substring(material.indexOf(":") + 1).toUpperCase());
            return NBTEditor.setItemTag(new ItemStack(type, (int)amount), tag, new Object[0]);
        }
        return null;
    }

    public static final Object getEntityTag(Entity entity, Object ... keys) {
        if (entity == null) {
            return entity;
        }
        try {
            Object NMSEntity = NBTEditor.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getEntityTag").invoke(NMSEntity, tag);
            return NBTEditor.getTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final NBTCompound getEntityNBTTag(Entity entity, Object ... keys) {
        if (entity == null) {
            return null;
        }
        try {
            Object NMSEntity = NBTEditor.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getEntityTag").invoke(NMSEntity, tag);
            return NBTEditor.getNBTTag(tag, keys);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static final void setEntityTag(Entity entity, Object value, Object ... keys) {
        if (entity == null) {
            return;
        }
        try {
            Object NMSEntity = NBTEditor.getMethod("getEntityHandle").invoke((Object)entity, new Object[0]);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getEntityTag").invoke(NMSEntity, tag);
            NBTEditor.setTag(tag, value, keys);
            NBTEditor.getMethod("setEntityTag").invoke(NMSEntity, tag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static final Object getBlockTag(Block block, Object ... keys) {
        block3: {
            try {
                if (block != null && NBTEditor.getNMSClass("CraftBlockState").isInstance(block.getState())) break block3;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        Location location = block.getLocation();
        Object blockPosition = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Object nmsWorld = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
        Object tileEntity = NBTEditor.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
        Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
        NBTEditor.getMethod("getTileTag").invoke(tileEntity, tag);
        return NBTEditor.getTag(tag, keys);
    }

    public static final Object getBlockNBTTag(Block block, Object ... keys) {
        block3: {
            try {
                if (block != null && NBTEditor.getNMSClass("CraftBlockState").isInstance(block.getState())) break block3;
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        Location location = block.getLocation();
        Object blockPosition = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Object nmsWorld = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
        Object tileEntity = NBTEditor.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
        Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
        NBTEditor.getMethod("getTileTag").invoke(tileEntity, tag);
        return NBTEditor.getNBTTag(tag, keys);
    }

    public static final void setBlockTag(Block block, Object value, Object ... keys) {
        try {
            if (block == null || !NBTEditor.getNMSClass("CraftBlockState").isInstance(block.getState())) {
                return;
            }
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            Object tag = NBTEditor.getNMSClass("NBTTagCompound").newInstance();
            NBTEditor.getMethod("getTileTag").invoke(tileEntity, tag);
            NBTEditor.setTag(tag, value, keys);
            NBTEditor.getMethod("setTileTag").invoke(tileEntity, tag);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static final void setSkullTexture(Block block, String texture) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(Base64.encodeBase64((byte[])String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", texture).getBytes()))));
        try {
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(NBTEditor.getNMSClass("BlockPosition")).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod("getWorldHandle").invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod("getTileEntity").invoke(nmsWorld, blockPosition);
            NBTEditor.getMethod("setGameProfile").invoke(tileEntity, profile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static final String getString(Object object, Object ... keys) {
        Object result;
        if (object instanceof ItemStack) {
            result = NBTEditor.getItemTag((ItemStack)object, keys);
        } else if (object instanceof Entity) {
            result = NBTEditor.getEntityTag((Entity)object, keys);
        } else if (object instanceof Block) {
            result = NBTEditor.getBlockTag((Block)object, keys);
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, or Block!");
        }
        return result instanceof String ? (String)result : null;
    }

    public static final int getInt(Object object, Object ... keys) {
        Object result;
        if (object instanceof ItemStack) {
            result = NBTEditor.getItemTag((ItemStack)object, keys);
        } else if (object instanceof Entity) {
            result = NBTEditor.getEntityTag((Entity)object, keys);
        } else if (object instanceof Block) {
            result = NBTEditor.getBlockTag((Block)object, keys);
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, or Block!");
        }
        return result instanceof Integer ? (Integer)result : 0;
    }

    public static final long getLong(Object object, Object ... keys) {
        Object result;
        if (object instanceof ItemStack) {
            result = NBTEditor.getItemTag((ItemStack)object, keys);
        } else if (object instanceof Entity) {
            result = NBTEditor.getEntityTag((Entity)object, keys);
        } else if (object instanceof Block) {
            result = NBTEditor.getBlockTag((Block)object, keys);
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, or Block!");
        }
        return result instanceof Long ? (Long)result : 0L;
    }

    public static final float getFloat(Object object, Object ... keys) {
        Object result;
        if (object instanceof ItemStack) {
            result = NBTEditor.getItemTag((ItemStack)object, keys);
        } else if (object instanceof Entity) {
            result = NBTEditor.getEntityTag((Entity)object, keys);
        } else if (object instanceof Block) {
            result = NBTEditor.getBlockTag((Block)object, keys);
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, or Block!");
        }
        return result instanceof Float ? ((Float)result).floatValue() : 0.0f;
    }

    public static final short getShort(Object object, Object ... keys) {
        Object result;
        if (object instanceof ItemStack) {
            result = NBTEditor.getItemTag((ItemStack)object, keys);
        } else if (object instanceof Entity) {
            result = NBTEditor.getEntityTag((Entity)object, keys);
        } else if (object instanceof Block) {
            result = NBTEditor.getBlockTag((Block)object, keys);
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, or Block!");
        }
        return result instanceof Short ? (Short)result : (short)0;
    }

    public static final byte getByte(Object object, Object ... keys) {
        Object result;
        if (object instanceof ItemStack) {
            result = NBTEditor.getItemTag((ItemStack)object, keys);
        } else if (object instanceof Entity) {
            result = NBTEditor.getEntityTag((Entity)object, keys);
        } else if (object instanceof Block) {
            result = NBTEditor.getBlockTag((Block)object, keys);
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, or Block!");
        }
        return result instanceof Byte ? (Byte)result : (byte)0;
    }

    public static final byte[] getByteArray(Object object, Object ... keys) {
        Object result;
        if (object instanceof ItemStack) {
            result = NBTEditor.getItemTag((ItemStack)object, keys);
        } else if (object instanceof Entity) {
            result = NBTEditor.getEntityTag((Entity)object, keys);
        } else if (object instanceof Block) {
            result = NBTEditor.getBlockTag((Block)object, keys);
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, or Block!");
        }
        return result instanceof byte[] ? (byte[])result : null;
    }

    public static final int[] getIntArray(Object object, Object ... keys) {
        Object result;
        if (object instanceof ItemStack) {
            result = NBTEditor.getItemTag((ItemStack)object, keys);
        } else if (object instanceof Entity) {
            result = NBTEditor.getEntityTag((Entity)object, keys);
        } else if (object instanceof Block) {
            result = NBTEditor.getBlockTag((Block)object, keys);
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, or Block!");
        }
        return result instanceof int[] ? (int[])result : null;
    }

    public static final boolean contains(Object object, Object ... keys) {
        Object result;
        if (object instanceof ItemStack) {
            result = NBTEditor.getItemTag((ItemStack)object, keys);
        } else if (object instanceof Entity) {
            result = NBTEditor.getEntityTag((Entity)object, keys);
        } else if (object instanceof Block) {
            result = NBTEditor.getBlockTag((Block)object, keys);
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, or Block!");
        }
        return result != null;
    }

    public static final <T> T set(T object, Object value, Object ... keys) {
        if (object instanceof ItemStack) {
            return (T)NBTEditor.setItemTag((ItemStack)object, value, keys);
        }
        if (object instanceof Entity) {
            NBTEditor.setEntityTag((Entity)object, value, keys);
        } else if (object instanceof Block) {
            NBTEditor.setBlockTag((Block)object, value, keys);
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, or Block!");
        }
        return object;
    }

    private static void setTag(Object tag, Object value, Object ... keys) throws Exception {
        Object notCompound = value != null ? (NBTEditor.getNMSClass("NBTTagList").isInstance(value) || NBTEditor.getNMSClass("NBTTagCompound").isInstance(value) ? value : NBTEditor.getConstructor(NBTEditor.getNBTTag(value.getClass())).newInstance(value)) : null;
        Object compound = tag;
        int index = 0;
        while (index < keys.length) {
            Object key = keys[index];
            if (index + 1 == keys.length) {
                if (key == null) {
                    if (VERSION.contains("1_14")) {
                        int type = (Integer)NBTEditor.getMethod("getTypeId").invoke(notCompound, new Object[0]);
                        NBTEditor.getMethod("add").invoke(compound, type, notCompound);
                        break;
                    }
                    NBTEditor.getMethod("add").invoke(compound, notCompound);
                    break;
                }
                if (key instanceof Integer) {
                    if (notCompound == null) {
                        NBTEditor.getMethod("listRemove").invoke(compound, (int)((Integer)key));
                        break;
                    }
                    NBTEditor.getMethod("setIndex").invoke(compound, (int)((Integer)key), notCompound);
                    break;
                }
                if (notCompound == null) {
                    NBTEditor.getMethod("remove").invoke(compound, (String)key);
                    break;
                }
                NBTEditor.getMethod("set").invoke(compound, (String)key, notCompound);
                break;
            }
            Object oldCompound = compound;
            if (key instanceof Integer) {
                compound = ((List)NBTListData.get(compound)).get((Integer)key);
            } else if (key != null) {
                compound = NBTEditor.getMethod("get").invoke(compound, (String)key);
            }
            if (compound == null || key == null) {
                compound = keys[index + 1] == null || keys[index + 1] instanceof Integer ? NBTEditor.getNMSClass("NBTTagList").newInstance() : NBTEditor.getNMSClass("NBTTagCompound").newInstance();
                if (oldCompound.getClass().getSimpleName().equals("NBTTagList")) {
                    NBTEditor.getMethod("add").invoke(oldCompound, compound);
                } else if (notCompound == null) {
                    NBTEditor.getMethod("remove").invoke(oldCompound, (String)key);
                } else {
                    NBTEditor.getMethod("set").invoke(oldCompound, (String)key, compound);
                }
            }
            ++index;
        }
    }

    private static NBTCompound getNBTTag(Object tag, Object ... keys) throws Exception {
        Object compound = tag;
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            if (compound == null) {
                return null;
            }
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(compound)) {
                compound = NBTEditor.getMethod("get").invoke(compound, (String)key);
            } else if (NBTEditor.getNMSClass("NBTTagList").isInstance(compound)) {
                compound = ((List)NBTListData.get(compound)).get((Integer)key);
            }
            ++n2;
        }
        return new NBTCompound(compound);
    }

    private static Object getTag(Object tag, Object ... keys) throws Exception {
        if (keys.length == 0) {
            return NBTEditor.getTags(tag);
        }
        Object notCompound = tag;
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            if (notCompound == null) {
                return null;
            }
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(notCompound)) {
                notCompound = NBTEditor.getMethod("get").invoke(notCompound, (String)key);
            } else if (NBTEditor.getNMSClass("NBTTagList").isInstance(notCompound)) {
                notCompound = ((List)NBTListData.get(notCompound)).get((Integer)key);
            } else {
                return NBTEditor.getNBTVar(notCompound);
            }
            ++n2;
        }
        if (notCompound == null) {
            return null;
        }
        if (NBTEditor.getNMSClass("NBTTagList").isInstance(notCompound)) {
            return NBTEditor.getTags(notCompound);
        }
        if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(notCompound)) {
            return NBTEditor.getTags(notCompound);
        }
        return NBTEditor.getNBTVar(notCompound);
    }

    private static Object getTags(Object tag) {
        HashMap<Object, Object> tags = new HashMap<Object, Object>();
        try {
            if (NBTEditor.getNMSClass("NBTTagCompound").isInstance(tag)) {
                Map tagCompound = (Map)NBTCompoundMap.get(tag);
                for (String key : tagCompound.keySet()) {
                    Object value = tagCompound.get(key);
                    if (NBTEditor.getNMSClass("NBTTagEnd").isInstance(value)) continue;
                    tags.put(key, NBTEditor.getTag(value, new Object[0]));
                }
            } else if (NBTEditor.getNMSClass("NBTTagList").isInstance(tag)) {
                List tagList = (List)NBTListData.get(tag);
                int index = 0;
                while (index < tagList.size()) {
                    Object value = tagList.get(index);
                    if (!NBTEditor.getNMSClass("NBTTagEnd").isInstance(value)) {
                        tags.put(index, NBTEditor.getTag(value, new Object[0]));
                    }
                    ++index;
                }
            } else {
                return NBTEditor.getNBTVar(tag);
            }
            return tags;
        }
        catch (Exception e) {
            e.printStackTrace();
            return tags;
        }
    }

    public static final class NBTCompound {
        protected final Object tag;

        protected NBTCompound(Object tag) {
            this.tag = tag;
        }
    }
}

