/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.utils;

import com.nefilto.gravy.Core;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Messages {
    private Core plugin;
    private HashMap<String, List<String>> msgs;
    private HashMap<String, List<String>> defaultMsgs;

    public Messages(Core plugin) {
        this.plugin = plugin;
        this.msgs = new HashMap();
        this.defaultMsgs = this.getDefaultMessages();
        this.loadMsgs();
    }

    public void loadMsgs() {
        this.setup();
        this.msgs.clear();
        if (this.plugin.getCfgm().getLangCfg().getConfigurationSection("Messages") != null) {
            for (String msgName : this.plugin.getCfgm().getLangCfg().getConfigurationSection("Messages").getKeys(false)) {
                List Msgs = this.plugin.getCfgm().getLangCfg().getStringList("Messages." + msgName);
                this.msgs.put(msgName, Msgs);
            }
        }
        for (Map.Entry<String, List<String>> option : this.defaultMsgs.entrySet()) {
            String key = option.getKey();
            List<String> value = option.getValue();
            if (this.msgs.containsKey(key)) continue;
            this.msgs.put(key, value);
            this.plugin.getCfgm().getLangCfg().set("Messages." + key, value);
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.YELLOW + "[+]" + key + ChatColor.RESET + " added to lang.yml");
        }
        this.plugin.getCfgm().saveLang();
    }

    private HashMap<String, List<String>> getDefaultMessages() {
        HashMap<String, List<String>> tempMsgs = new HashMap<String, List<String>>();
        String m1 = "list_graves_msg";
        ArrayList<String> l1 = new ArrayList<String>(Arrays.asList("[\u2605] Grave in [&7%%world%%&r] at [&4%%xpos%%&r][&a%%ypos%%&r][&9%%zpos%%&r] time left [&d%%time%%&r]"));
        String m2 = "graves_not_found_msg";
        ArrayList<String> l2 = new ArrayList<String>(Arrays.asList("&4[\u2716] No Graves Found!"));
        String m3 = "player_not_found_msg";
        ArrayList<String> l3 = new ArrayList<String>(Arrays.asList("&4[\u2716] Player doesn''t exist or Offline!"));
        String m4 = "invalid_world_msg";
        ArrayList<String> l4 = new ArrayList<String>(Arrays.asList("&4[\u2716] World [%%world%%] does not exist!"));
        String m5 = "world_disabled_msg";
        ArrayList<String> l5 = new ArrayList<String>(Arrays.asList("&e[\u00a1] &rWorld &e[%%world%%] &rhas been &4disabled!"));
        String m6 = "world_already_disabled_msg";
        ArrayList<String> l6 = new ArrayList<String>(Arrays.asList("&e[\u00a1] &rWorld &e[%%world%%] &ris already &4disabled!"));
        String m7 = "world_enable_msg";
        ArrayList<String> l7 = new ArrayList<String>(Arrays.asList("&e[\u00a1] &rWorld &e[%%world%%] &rhas been &2enabled!"));
        String m8 = "world_already_enabled_msg";
        ArrayList<String> l8 = new ArrayList<String>(Arrays.asList("&e[\u00a1] &rWorld &e[%%world%%] &ris already &2enabled!"));
        String m9 = "breaking_grave_msg";
        ArrayList<String> l9 = new ArrayList<String>(Arrays.asList("&e[\u00a1] &rYou've broken a grave!"));
        String m10 = "protected_grave_msg";
        ArrayList<String> l10 = new ArrayList<String>(Arrays.asList("[\u2620] A Powerful Spirit is guarding this grave!"));
        String m11 = "grave_right_click_msg";
        ArrayList<String> l11 = new ArrayList<String>(Arrays.asList("&rGrave Owner : &2%%grave_owner%%", "&rTime Left : &5%%time%%"));
        String m12 = "teleport_to_grave_msg";
        ArrayList<String> l12 = new ArrayList<String>(Arrays.asList("&2[\u2714] You've been teleported to your grave location!"));
        String m13 = "dimension_teleport_warning_msg";
        ArrayList<String> l13 = new ArrayList<String>(Arrays.asList("&e[\u00a1] &rYou can only teleport to graves in the same dimension!"));
        String m14 = "grave_expiring_msg";
        ArrayList<String> l14 = new ArrayList<String>(Arrays.asList("&e[\u00a1] &rYour grave at :", "[&4%%xpos%%&r][&a%%ypos%%&r][&9%%zpos%%&r][%%world%%]", "&4expires &rin [&d%%time%%&r]"));
        String m15 = "expired_grave_msg";
        ArrayList<String> l15 = new ArrayList<String>(Arrays.asList("&e[\u00a1] &rYour grave at :", "[&4%%xpos%%&r][&a%%ypos%%&r][&9%%zpos%%&r][%%world%%]", "&rhas &4expired!"));
        String m16 = "token_lore";
        ArrayList<String> l16 = new ArrayList<String>(Arrays.asList("", "This item will be consumed", "if the player die", "in order to spawn a grave", "containing all the player items."));
        String m17 = "token_item_name";
        ArrayList<String> l17 = new ArrayList<String>(Arrays.asList("&r[&7&lGravy &6&lToken&r]"));
        String m18 = "inventory_full_msg";
        ArrayList<String> l18 = new ArrayList<String>(Arrays.asList("&4[\u2716] Inventory Full!"));
        String m19 = "token_consumed_msg";
        ArrayList<String> l19 = new ArrayList<String>(Arrays.asList("&e[\u00a1] &rx1 " + (String)l17.get(0) + " has been consumed!"));
        String m20 = "chat_prefix";
        ArrayList<String> l20 = new ArrayList<String>(Arrays.asList("&7[GR]&r"));
        String m21 = "update_available_msg";
        ArrayList<String> l21 = new ArrayList<String>(Arrays.asList("&e[\u00a1] &rA new update for Gravy[&e%version%&r]", "        is available at:", "        [&e%url%&r]"));
        String m22 = "recover_gui_grave_lore";
        ArrayList<String> l22 = new ArrayList<String>(Arrays.asList("", "[&4x&r][%%xpos%%]", "[&2y&r][%%ypos%%]", "[&9z&r][%%zpos%%]", "[world][%%world%%]", "[&5timer&r][%%time%%]"));
        String m23 = "recover_gui_grave_name";
        ArrayList<String> l23 = new ArrayList<String>(Arrays.asList("&4Death Point"));
        String m24 = "vault_no_account_msg";
        ArrayList<String> l24 = new ArrayList<String>(Arrays.asList("&e[\u00a1] &rNo Account found for player [&4%%player%%&r]"));
        String m25 = "vault_error_msg";
        ArrayList<String> l25 = new ArrayList<String>(Arrays.asList("&4[\u2716] An error occured!:", "&r[&e%%error%%&r]"));
        String m26 = "vault_grave_cost_subtracted_msg";
        ArrayList<String> l26 = new ArrayList<String>(Arrays.asList("&e[\u00a1]&r[&4%%amount%%&r] removed! and now have [&2%%balance%%&r]"));
        String m27 = "vault_not_enough_funds_msg";
        ArrayList<String> l27 = new ArrayList<String>(Arrays.asList("&e[\u00a1] can't spawn grave!:", "-&r[&2%%amount%%&r] required! you have [&4%%balance%%&r]"));
        tempMsgs.put(m1, l1);
        tempMsgs.put(m2, l2);
        tempMsgs.put(m3, l3);
        tempMsgs.put(m4, l4);
        tempMsgs.put(m5, l5);
        tempMsgs.put(m6, l6);
        tempMsgs.put(m7, l7);
        tempMsgs.put(m8, l8);
        tempMsgs.put(m9, l9);
        tempMsgs.put(m10, l10);
        tempMsgs.put(m11, l11);
        tempMsgs.put(m12, l12);
        tempMsgs.put(m13, l13);
        tempMsgs.put(m14, l14);
        tempMsgs.put(m15, l15);
        tempMsgs.put(m16, l16);
        tempMsgs.put(m17, l17);
        tempMsgs.put(m18, l18);
        tempMsgs.put(m19, l19);
        tempMsgs.put(m20, l20);
        tempMsgs.put(m21, l21);
        tempMsgs.put(m22, l22);
        tempMsgs.put(m23, l23);
        tempMsgs.put(m24, l24);
        tempMsgs.put(m25, l25);
        tempMsgs.put(m26, l26);
        tempMsgs.put(m27, l27);
        return tempMsgs;
    }

    private void setup() {
        if (this.plugin.getCfgm().getLangCfg().getConfigurationSection("Messages") == null) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.YELLOW + "Generating lang.yml File :");
            this.plugin.getCfgm().getLangCfg().createSection("Messages");
            for (Map.Entry<String, List<String>> entryOptions : this.defaultMsgs.entrySet()) {
                String index = entryOptions.getKey();
                List<String> msgs = entryOptions.getValue();
                this.plugin.getCfgm().getLangCfg().set("Messages." + index, msgs);
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.YELLOW + "[+]" + index + ChatColor.RESET + " added to lang.yml");
            }
            this.plugin.getCfgm().saveLang();
        }
    }

    public void display(String key, Player player) {
        if (player != null) {
            if (this.msgs.containsKey(key)) {
                int index = 0;
                for (String msg : this.msgs.get(key)) {
                    if (this.plugin.getConfig().getBoolean("enable_chat_prefix") && index == 0) {
                        msg = String.valueOf(this.msgs.get("chat_prefix").get(0)) + msg;
                    }
                    msg = this.plugin.setPlaceholderAPI(msg, player);
                    this.plugin.getChatUtil().sendMessage(player, msg);
                    ++index;
                }
            } else {
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " '" + key + "' Is Missing from lang.yml!");
            }
        }
    }

    public void display(String key, Player player, HashMap<String, String> options) {
        if (player != null) {
            if (this.msgs.containsKey(key)) {
                ArrayList<String> output = new ArrayList<String>();
                int index = 0;
                for (String msg : this.msgs.get(key)) {
                    for (Map.Entry<String, String> option : options.entrySet()) {
                        String oKey = option.getKey();
                        String oVal = option.getValue();
                        if (!msg.contains(oKey)) continue;
                        msg = msg.replace(oKey, oVal);
                    }
                    if (this.plugin.getConfig().getBoolean("enable_chat_prefix") && index == 0) {
                        msg = String.valueOf(this.msgs.get("chat_prefix").get(0)) + msg;
                    }
                    ++index;
                    output.add(msg);
                }
                for (String msg : output) {
                    msg = this.plugin.setPlaceholderAPI(msg, player);
                    this.plugin.getChatUtil().sendMessage(player, msg);
                }
            } else {
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " '" + key + "' Is Missing from lang.yml!");
            }
        }
    }

    public List<String> getMsg(String key, Player player) {
        ArrayList<String> m = new ArrayList<String>();
        if (this.msgs.containsKey(key)) {
            for (String msg : this.msgs.get(key)) {
                msg = this.plugin.setPlaceholderAPI(msg, player);
                m.add(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
            }
        } else {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " '" + key + "' Is Missing from lang.yml!");
        }
        return m;
    }

    public List<String> getMsg(String key) {
        ArrayList<String> m = new ArrayList<String>();
        if (this.msgs.containsKey(key)) {
            for (String msg : this.msgs.get(key)) {
                m.add(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
            }
        } else {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " '" + key + "' Is Missing from lang.yml!");
        }
        return m;
    }

    public String listToString(List<String> list) {
        String m = "";
        for (String s : list) {
            m = String.valueOf(m) + ChatColor.translateAlternateColorCodes((char)'&', (String)s);
            m = String.valueOf(m) + " ";
        }
        return m;
    }

    public List<String> getPopulatedMsg(String key, HashMap<String, String> options, Player player) {
        if (this.msgs.containsKey(key)) {
            ArrayList<String> output = new ArrayList<String>();
            for (String msg : this.msgs.get(key)) {
                for (Map.Entry<String, String> option : options.entrySet()) {
                    String oKey = option.getKey();
                    String oVal = option.getValue();
                    if (!msg.contains(oKey)) continue;
                    msg = msg.replace(oKey, oVal);
                }
                if (this.plugin.getConfig().getBoolean("enable_chat_prefix")) {
                    msg = String.valueOf(this.msgs.get("chat_prefix").get(0)) + msg;
                }
                msg = this.plugin.setPlaceholderAPI(msg, player);
                output.add(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
            }
            return output;
        }
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " '" + key + "' Is Missing from lang.yml!");
        return null;
    }
}

