/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.utils;

import com.nefilto.gravy.Core;
import de.tr7zw.nbtapi.NBTItem;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DeathPointUtil {
    private Core plugin;

    public DeathPointUtil(Core plugin) {
        this.plugin = plugin;
    }

    public ItemStack makeDeathPoint(World world, Location loc, Block block) {
        int timer;
        ItemStack item = new ItemStack(Material.GRASS_BLOCK);
        if (world.getName().contains("_nether")) {
            item.setType(Material.NETHERRACK);
        }
        if (world.getName().contains("_end")) {
            item.setType(Material.END_STONE);
        }
        ItemMeta meta = item.getItemMeta();
        Player player = this.plugin.getPlayerSkullsManager().getPlayerFromBlock(block);
        int timers = timer = this.plugin.getPlayerSkullsManager().getBlockTime(block).intValue();
        timers = timer / 20;
        int hours = timers / 3600;
        int remainder = timers - hours * 3600;
        int mins = remainder / 60;
        int secs = remainder -= mins * 60;
        String time = String.valueOf(hours) + "h" + mins + "m" + secs + "s";
        meta.setDisplayName(this.plugin.getMsgsUtil().listToString(this.plugin.getMsgsUtil().getMsg("recover_gui_grave_name", player)));
        String worldS = this.plugin.getChatUtil().getWorldAlias(world.getName());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("%%world%%", worldS);
        options.put("%%xpos%%", "" + loc.getBlockX());
        options.put("%%ypos%%", "" + loc.getBlockY());
        options.put("%%zpos%%", "" + loc.getBlockZ());
        options.put("%%time%%", time);
        options.put("%%hours%%", Integer.toString(hours));
        options.put("%%minutes%%", Integer.toString(mins));
        options.put("%%seconds%%", Integer.toString(secs));
        meta.setLore(this.plugin.getMsgsUtil().getPopulatedMsg("recover_gui_grave_lore", options, player));
        item.setItemMeta(meta);
        NBTItem nbti = new NBTItem(item);
        nbti.setBoolean("isDeathPoint", Boolean.valueOf(true));
        nbti.setInteger("x", Integer.valueOf(loc.getBlockX()));
        nbti.setInteger("y", Integer.valueOf(loc.getBlockY()));
        nbti.setInteger("z", Integer.valueOf(loc.getBlockZ()));
        nbti.setString("world", world.getName());
        return nbti.getItem();
    }

    public static boolean isDeathPoint(ItemStack item) {
        boolean isDeathPoint = false;
        if (item != null) {
            NBTItem nbtItem = new NBTItem(item);
            try {
                if (nbtItem.hasKey("isDeathPoint").booleanValue()) {
                    isDeathPoint = true;
                }
            }
            catch (Exception e) {
                return isDeathPoint;
            }
        }
        return isDeathPoint;
    }

    public static int[] getDeathPointCoordinates(ItemStack item) {
        if (DeathPointUtil.isDeathPoint(item)) {
            NBTItem nbti = new NBTItem(item);
            if (nbti.getInteger("x") != null && nbti.getInteger("y") != null && nbti.getInteger("z") != null) {
                return new int[]{nbti.getInteger("x"), nbti.getInteger("y"), nbti.getInteger("z")};
            }
            return null;
        }
        return null;
    }

    public static World getDeathPointWorld(ItemStack item) {
        World world = null;
        if (item != null) {
            NBTItem nbti = new NBTItem(item);
            world = Bukkit.getWorld((String)nbti.getString("world"));
        }
        return world;
    }
}

