/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.utils;

import com.nefilto.gravy.Core;
import com.nefilto.gravy.enumes.DefaultFontInfo;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class ChatUtil {
    private Core plugin;
    private final int CENTER_PX = 154;
    private final int MAX_PX = 250;
    private final String HR;

    public ChatUtil(Core plugin) {
        this.plugin = plugin;
        this.HR = ChatColor.STRIKETHROUGH + this.repeat(" ", 80);
    }

    public String getHR() {
        String hr = String.valueOf(ChatColor.translateAlternateColorCodes((char)'&', (String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getConfig().getString("chat_line_color")))) + this.HR;
        return hr;
    }

    public void sendCenteredMessage(Player player, String message) {
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        int charIndex = 0;
        int lastSpaceIndex = 0;
        String toSendAfter = null;
        String recentColorCode = "";
        char[] cArray = message.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                block10: {
                    char c;
                    block8: {
                        block9: {
                            block6: {
                                c = cArray[n2];
                                if (c != '\u00a7') break block6;
                                previousCode = true;
                                break block7;
                            }
                            if (!previousCode) break block8;
                            previousCode = false;
                            recentColorCode = "\u00a7" + c;
                            if (c != 'l' && c != 'L') break block9;
                            isBold = true;
                            break block7;
                        }
                        isBold = false;
                        break block10;
                    }
                    if (c == ' ') {
                        lastSpaceIndex = charIndex;
                    } else {
                        DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
                        messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
                        ++messagePxSize;
                    }
                }
                if (messagePxSize >= 250) {
                    toSendAfter = String.valueOf(recentColorCode) + message.substring(lastSpaceIndex + 1, message.length());
                    message = message.substring(0, lastSpaceIndex + 1);
                    break;
                }
                ++charIndex;
            }
            ++n2;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = 154 - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        int compensated = 0;
        StringBuilder sb = new StringBuilder();
        while (compensated < toCompensate) {
            sb.append(" ");
            compensated += spaceLength;
        }
        player.sendMessage(String.valueOf(sb.toString()) + message);
        if (toSendAfter != null) {
            this.sendCenteredMessage(player, toSendAfter);
        }
    }

    public void sendMessage(Player player, String message) {
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        if (this.plugin.isUsingPlaceholderAPI()) {
            message = this.plugin.setPlaceholderAPI(message, player);
        }
        if (player.isOnline()) {
            player.sendMessage(message);
        }
    }

    public String repeat(String txt, int count) {
        String finalString = "";
        int i = 0;
        while (i < count) {
            finalString = String.valueOf(finalString) + txt;
            ++i;
        }
        return finalString;
    }

    public void spacer(Player player, int count) {
        String message = "";
        int i = 0;
        while (i < count) {
            message = String.valueOf(message) + " \n";
            ++i;
        }
        player.sendMessage(message);
    }

    public String getWorldAlias(String world) {
        String result = world;
        if (this.plugin.getConfig().isSet("worlds_aliases")) {
            for (String keys : this.plugin.getConfig().getStringList("worlds_aliases")) {
                String[] combo = keys.split("::");
                if (combo.length <= 1 || !combo[0].equalsIgnoreCase(world)) continue;
                result = combo[1];
            }
        }
        return result;
    }
}

