/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.utils;

import com.nefilto.gravy.Core;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.entity.Player;

public class BlockUtils {
    private Core plugin;

    public BlockUtils(Core plugin) {
        this.plugin = plugin;
    }

    public Location lookForAir(Location start) {
        Location loc = new Location(start.getWorld(), start.getX(), start.getY(), start.getZ());
        World world = loc.getWorld();
        Block block = world.getBlockAt(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        Block blockAbove = world.getBlockAt(block.getLocation().getBlockX(), block.getLocation().getBlockY() + 1, block.getLocation().getBlockZ());
        boolean looking = true;
        if (!block.getType().equals((Object)Material.AIR) && !blockAbove.getType().equals((Object)Material.AIR)) {
            do {
                block = world.getBlockAt(block.getLocation().getBlockX(), block.getLocation().getBlockY() + 1, block.getLocation().getBlockZ());
                blockAbove = world.getBlockAt(block.getLocation().getBlockX(), block.getLocation().getBlockY() + 1, block.getLocation().getBlockZ());
                if (!block.getType().equals((Object)Material.AIR) || !blockAbove.getType().equals((Object)Material.AIR)) continue;
                loc = block.getLocation();
                looking = false;
            } while (looking);
        } else {
            loc = block.getLocation();
            this.plugin.getDebugger().showMessage("- Found AIR Blocks At \n x : " + loc.getX() + " | y : " + loc.getY() + " | z : " + loc.getZ());
            if (!world.getName().equalsIgnoreCase("nether") && loc.getY() > 125.0) {
                loc = start;
            }
        }
        return loc;
    }

    public void placePlayerSkull(Player player, Block block) {
        block.setType(Material.PLAYER_HEAD);
        Skull skullData = (Skull)block.getState();
        skullData.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)player.getUniqueId()));
        skullData.update();
        block.getState().update(true);
    }
}

