/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.tasks;

import com.nefilto.gravy.Core;
import com.nefilto.gravy.managers.PlayerInventoryManager;
import com.nefilto.gravy.managers.PlayerSkullsManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class WatchGarvesTask
extends BukkitRunnable {
    private Core plugin;
    private PlayerSkullsManager psm;
    private PlayerInventoryManager pim;

    public WatchGarvesTask(Core plugin) {
        this.plugin = plugin;
        this.psm = this.plugin.getPlayerSkullsManager();
        this.pim = this.plugin.getPlayerInventoryManager();
    }

    public void run() {
        for (Map.Entry<String, Integer> entryOptions : this.psm.getSkullList().entrySet()) {
            String index = entryOptions.getKey();
            List<String> data = this.psm.getIndexAsList(index);
            if (data.size() < 5) {
                return;
            }
            Integer timer = entryOptions.getValue();
            UUID playerID = UUID.fromString(data.get(0));
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerID);
            World world = Bukkit.getWorld((String)data.get(1));
            int x = Integer.parseInt(data.get(2));
            int y = Integer.parseInt(data.get(3));
            int z = Integer.parseInt(data.get(4));
            world.loadChunk(world.getBlockAt(x, y, z).getChunk());
            Block block = world.getBlockAt(x, y, z);
            int timeTick = 20;
            int timers = timer;
            timers = timer / 20;
            int hours = timers / 3600;
            int remainder = timers - hours * 3600;
            int mins = remainder / 60;
            int secs = remainder -= mins * 60;
            String time = String.valueOf(hours) + "h" + mins + "m" + secs + "s";
            String worldName = this.plugin.getChatUtil().getWorldAlias(world.getName());
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("%%world%%", worldName);
            options.put("%%xpos%%", Integer.toString(x));
            options.put("%%ypos%%", Integer.toString(y));
            options.put("%%zpos%%", Integer.toString(z));
            options.put("%%time%%", time);
            options.put("%%hours%%", Integer.toString(hours));
            options.put("%%minutes%%", Integer.toString(mins));
            options.put("%%seconds%%", Integer.toString(secs));
            if (offlinePlayer == null) continue;
            Player player = offlinePlayer.getPlayer();
            if (player != null) {
                if (timer == 6000) {
                    this.plugin.getMsgsUtil().display("grave_expiring_msg", player, options);
                }
                if (timer == 1200) {
                    this.plugin.getMsgsUtil().display("grave_expiring_msg", player, options);
                }
                if (timer == 200) {
                    this.plugin.getMsgsUtil().display("grave_expiring_msg", player, options);
                }
            }
            if (timer <= 0) {
                Block blockunder = block.getWorld().getBlockAt(block.getLocation().subtract(0.0, 2.0, 0.0));
                Block blockDirt = block.getWorld().getBlockAt(block.getLocation().subtract(0.0, 1.0, 0.0));
                block.setType(Material.AIR);
                if (!blockunder.getType().equals((Object)Material.LAVA) && (blockDirt.getType().equals((Object)Material.DIRT) || blockDirt.getType().equals((Object)Material.GRASS))) {
                    blockDirt.setType(Material.AIR);
                }
                this.plugin.getMsgsUtil().display("expired_grave_msg", player, options);
                this.pim.dropInventoryItems(this.psm.stringify(playerID, block), block);
                this.psm.removeSkull(index);
                continue;
            }
            if (player != null && player.hasPermission("grave.notimer")) {
                timeTick = 0;
            }
            if ((timer = Integer.valueOf(timer - timeTick)) < 0) {
                timer = 0;
            }
            this.psm.getSkullList().put(index, timer);
        }
    }
}

