/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.managers;

import com.nefilto.gravy.Core;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class PlayerSkullsManager {
    private Core plugin;
    private ConcurrentHashMap<String, Integer> skullList;
    private int graveTimer;

    public PlayerSkullsManager(Core plugin) {
        this.plugin = plugin;
        this.skullList = new ConcurrentHashMap();
        this.graveTimer = plugin.getConfig().getInt("grave_timer") * 20;
    }

    public void clearSkulls() {
        this.skullList.clear();
        this.plugin.getDebugger().showMessage("- The Skull List was cleared");
    }

    public String stringify(UUID id, Block block) {
        String blockString = "";
        blockString = String.valueOf(blockString) + id.toString();
        blockString = String.valueOf(blockString) + "::";
        blockString = String.valueOf(blockString) + block.getWorld().getName();
        blockString = String.valueOf(blockString) + "::";
        blockString = String.valueOf(blockString) + block.getLocation().getBlockX();
        blockString = String.valueOf(blockString) + "::";
        blockString = String.valueOf(blockString) + block.getLocation().getBlockY();
        blockString = String.valueOf(blockString) + "::";
        blockString = String.valueOf(blockString) + block.getLocation().getBlockZ();
        return blockString;
    }

    public void saveToConfig() {
        for (Map.Entry<String, Integer> entryOptions : this.skullList.entrySet()) {
            String index = entryOptions.getKey();
            Integer timer = entryOptions.getValue();
            this.saveSkull(index, timer);
        }
    }

    public ConcurrentHashMap<String, Integer> getSkullList() {
        return this.skullList;
    }

    private void saveSkull(String skull, int timer) {
        HashMap<String, Integer> graves = new HashMap<String, Integer>();
        if (this.plugin.getCfgm().getGravesCfg().getConfigurationSection("graves") != null) {
            for (String string : this.plugin.getCfgm().getGravesCfg().getConfigurationSection("graves").getKeys(false)) {
                int time = this.plugin.getCfgm().getGravesCfg().getInt("graves." + string + ".timer");
                graves.put(string, time);
            }
        }
        this.plugin.getDebugger().showMessage("- list from config :" + graves.toString());
        graves.put(skull, timer);
        this.plugin.getDebugger().showMessage("- list from config after adding the skull :" + graves.toString());
        for (Map.Entry entry : graves.entrySet()) {
            String index = (String)entry.getKey();
            Integer time = (Integer)entry.getValue();
            this.plugin.getCfgm().getGravesCfg().set("graves." + index + ".timer", (Object)time);
        }
        this.plugin.getCfgm().saveGraves();
    }

    private void unsaveSkull(String skull) {
        ArrayList<String> graves = new ArrayList<String>();
        if (this.plugin.getCfgm().getGravesCfg().getConfigurationSection("graves") != null) {
            for (String grave : this.plugin.getCfgm().getGravesCfg().getConfigurationSection("graves").getKeys(false)) {
                graves.add(grave);
            }
        }
        if (graves.contains(skull)) {
            this.plugin.getCfgm().getGravesCfg().set("graves." + skull, null);
            this.plugin.getCfgm().saveGraves();
        }
    }

    public void loadSkulls() {
        if (this.plugin.getCfgm().getGravesCfg().getConfigurationSection("graves") != null) {
            for (String grave : this.plugin.getCfgm().getGravesCfg().getConfigurationSection("graves").getKeys(false)) {
                this.skullList.put(grave, this.plugin.getCfgm().getGravesCfg().getInt("graves." + grave + ".timer"));
            }
        }
    }

    public void addSkull(Player player, Block block) {
        String index = this.stringify(player.getUniqueId(), block);
        this.skullList.put(index, this.graveTimer);
        this.saveSkull(index, this.graveTimer);
        Inventory inv = Bukkit.getServer().createInventory(null, 54);
        ItemStack[] itemStackArray = player.getInventory().getContents();
        int n = itemStackArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            if (item != null) {
                if (this.plugin.getServerVersion().contains("v1_7") || this.plugin.getServerVersion().contains("v1_8") || this.plugin.getServerVersion().contains("v1_9") || this.plugin.getServerVersion().contains("v1_10")) {
                    inv.addItem(new ItemStack[]{item});
                } else if (!item.containsEnchantment(Enchantment.VANISHING_CURSE)) {
                    inv.addItem(new ItemStack[]{item});
                }
            }
            ++n2;
        }
        this.plugin.getPlayerInventoryManager().addInventory(index, inv);
        this.plugin.getDebugger().showMessage("- A skull Was Added to the skull List \n [" + index + " | " + this.graveTimer + "]");
    }

    public void removeSkull(String index) {
        if (this.skullList.containsKey(index)) {
            this.unsaveSkull(index);
            this.skullList.remove(index);
            this.plugin.getPlayerInventoryManager().removeInventory(index);
            this.plugin.getDebugger().showMessage("- A skull Was Removed from the skull List \n [" + index + "]");
        }
    }

    public List<String> getIndexAsList(String index) {
        return Arrays.asList(index.split("::"));
    }

    public boolean containBlock(Block block) {
        boolean exists = false;
        Integer blockX = block.getLocation().getBlockX();
        Integer blockY = block.getLocation().getBlockY();
        Integer blockZ = block.getLocation().getBlockZ();
        World blockWorld = block.getWorld();
        for (Map.Entry<String, Integer> entryOptions : this.skullList.entrySet()) {
            String index = entryOptions.getKey();
            this.plugin.getDebugger().showMessage("- Looking in \n [" + index + "]\n - For : " + block.toString());
            List<String> blockListInfo = this.getIndexAsList(index);
            if (!blockWorld.getName().equals(blockListInfo.get(1)) || !blockX.toString().equalsIgnoreCase(blockListInfo.get(2)) || !blockY.toString().equalsIgnoreCase(blockListInfo.get(3)) || !blockZ.toString().equalsIgnoreCase(blockListInfo.get(4))) continue;
            this.plugin.getDebugger().showMessage("- Match found in \n [" + index + "]\n - For : " + block.toString());
            exists = true;
        }
        return exists;
    }

    public List<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (Map.Entry<String, Integer> entryOptions : this.skullList.entrySet()) {
            String index = entryOptions.getKey();
            List<String> blockListInfo = this.getIndexAsList(index);
            int x = Integer.parseInt(blockListInfo.get(2));
            int y = Integer.parseInt(blockListInfo.get(3));
            int z = Integer.parseInt(blockListInfo.get(4));
            Block b = Bukkit.getWorld((String)blockListInfo.get(1)).getBlockAt(x, y, z);
            if (b == null) continue;
            blocks.add(b);
        }
        return blocks;
    }

    public UUID getIdFromBlock(Block block) {
        UUID playerId = null;
        Integer blockX = block.getLocation().getBlockX();
        Integer blockY = block.getLocation().getBlockY();
        Integer blockZ = block.getLocation().getBlockZ();
        World blockWorld = block.getWorld();
        for (Map.Entry<String, Integer> entryOptions : this.skullList.entrySet()) {
            String index = entryOptions.getKey();
            this.plugin.getDebugger().showMessage("- Looking in \n [" + index + "]\n - For : " + block.toString());
            List<String> blockListInfo = this.getIndexAsList(index);
            if (!blockWorld.getName().equals(blockListInfo.get(1)) || !blockX.toString().equalsIgnoreCase(blockListInfo.get(2)) || !blockY.toString().equalsIgnoreCase(blockListInfo.get(3)) || !blockZ.toString().equalsIgnoreCase(blockListInfo.get(4))) continue;
            this.plugin.getDebugger().showMessage("- Match found in \n [" + index + "]\n - For : " + block.toString());
            playerId = UUID.fromString(blockListInfo.get(0));
        }
        return playerId;
    }

    public Integer getBlockTime(Block block) {
        Integer blockTimer = 0;
        Integer blockX = block.getLocation().getBlockX();
        Integer blockY = block.getLocation().getBlockY();
        Integer blockZ = block.getLocation().getBlockZ();
        World blockWorld = block.getWorld();
        for (Map.Entry<String, Integer> entryOptions : this.skullList.entrySet()) {
            String index = entryOptions.getKey();
            Integer timer = entryOptions.getValue();
            this.plugin.getDebugger().showMessage("- Looking in \n [" + index + "]\n - For : " + block.toString());
            List<String> blockListInfo = this.getIndexAsList(index);
            if (!blockWorld.getName().equals(blockListInfo.get(1)) || !blockX.toString().equalsIgnoreCase(blockListInfo.get(2)) || !blockY.toString().equalsIgnoreCase(blockListInfo.get(3)) || !blockZ.toString().equalsIgnoreCase(blockListInfo.get(4))) continue;
            this.plugin.getDebugger().showMessage("- Match found in \n [" + index + "]\n - For : " + block.toString());
            blockTimer = timer;
        }
        return blockTimer;
    }

    public Player getPlayerFromBlock(Block block) {
        Player player = null;
        Integer blockX = block.getLocation().getBlockX();
        Integer blockY = block.getLocation().getBlockY();
        Integer blockZ = block.getLocation().getBlockZ();
        World blockWorld = block.getWorld();
        for (Map.Entry<String, Integer> entryOptions : this.skullList.entrySet()) {
            String index = entryOptions.getKey();
            this.plugin.getDebugger().showMessage("- Looking in \n [" + index + "]\n - For : " + block.toString());
            List<String> blockListInfo = this.getIndexAsList(index);
            if (!blockWorld.getName().equals(blockListInfo.get(1)) || !blockX.toString().equalsIgnoreCase(blockListInfo.get(2)) || !blockY.toString().equalsIgnoreCase(blockListInfo.get(3)) || !blockZ.toString().equalsIgnoreCase(blockListInfo.get(4))) continue;
            this.plugin.getDebugger().showMessage("- Match found in \n [" + index + "]\n - For : " + block.toString());
            player = Bukkit.getPlayer((UUID)UUID.fromString(blockListInfo.get(0)));
        }
        return player;
    }

    public List<Block> getPlayerBlocks(Player player) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        UUID playerID = player.getUniqueId();
        for (Map.Entry<String, Integer> entryOptions : this.skullList.entrySet()) {
            String index = entryOptions.getKey();
            List<String> indexAsList = this.getIndexAsList(index);
            if (!UUID.fromString(indexAsList.get(0)).equals(playerID)) continue;
            int x = Integer.parseInt(indexAsList.get(2));
            int y = Integer.parseInt(indexAsList.get(3));
            int z = Integer.parseInt(indexAsList.get(4));
            blocks.add(Bukkit.getWorld((String)indexAsList.get(1)).getBlockAt(x, y, z));
        }
        return blocks;
    }
}

