/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.managers;

import com.nefilto.gravy.Core;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class PlayerInventoryManager {
    private Core plugin;
    private ConcurrentHashMap<String, Inventory> inventoryList;

    public PlayerInventoryManager(Core plugin) {
        this.plugin = plugin;
        this.inventoryList = new ConcurrentHashMap();
    }

    public void addInventory(String index, Inventory inventory) {
        String base64Inventory = this.toBase64(inventory);
        this.inventoryList.put(index, inventory);
        this.saveInventory(index, base64Inventory);
    }

    public ConcurrentHashMap<String, Inventory> getInventoryList() {
        return this.inventoryList;
    }

    private void saveInventory(String index, String base64Inventory) {
        HashMap<String, String> inventories = new HashMap<String, String>();
        if (this.plugin.getCfgm().getItemsCfg().getConfigurationSection("items") != null) {
            for (String inventoryIndex : this.plugin.getCfgm().getItemsCfg().getConfigurationSection("items").getKeys(false)) {
                String base64Inv = this.plugin.getCfgm().getItemsCfg().getString("items." + inventoryIndex + ".inv");
                inventories.put(inventoryIndex, base64Inv);
            }
        }
        inventories.put(index, base64Inventory);
        for (Map.Entry entryOptions : inventories.entrySet()) {
            String inventoryIndex = (String)entryOptions.getKey();
            String base64inv = (String)entryOptions.getValue();
            this.plugin.getCfgm().getItemsCfg().set("items." + inventoryIndex + ".inv", (Object)base64inv);
        }
        this.plugin.getCfgm().saveItems();
        this.plugin.getDebugger().showMessage("- Inventory Was added to config \n [" + index + "]");
    }

    private void unsaveInventory(String index) {
        HashMap<String, String> inventories = new HashMap<String, String>();
        if (this.plugin.getCfgm().getItemsCfg().getConfigurationSection("items") != null) {
            for (String inventoryIndex : this.plugin.getCfgm().getItemsCfg().getConfigurationSection("items").getKeys(false)) {
                String base64Inv = this.plugin.getCfgm().getItemsCfg().getString("items." + inventoryIndex + ".inv");
                inventories.put(inventoryIndex, base64Inv);
            }
        }
        if (inventories.containsKey(index)) {
            this.plugin.getCfgm().getItemsCfg().set("items." + index, null);
            this.plugin.getCfgm().saveItems();
            this.plugin.getDebugger().showMessage("- Inventory Was Removed from the Config \n [" + index + "]");
        }
    }

    public void loadInventory() throws IOException {
        if (this.plugin.getCfgm().getItemsCfg().getConfigurationSection("items") != null) {
            for (String inventoryIndex : this.plugin.getCfgm().getItemsCfg().getConfigurationSection("items").getKeys(false)) {
                String base64Inv = this.plugin.getCfgm().getItemsCfg().getString("items." + inventoryIndex + ".inv");
                if (base64Inv == null || base64Inv == "") continue;
                this.inventoryList.put(inventoryIndex, this.fromBase64(base64Inv));
            }
        }
    }

    public void saveToConfig() {
        ConcurrentHashMap<String, Inventory> tempList = new ConcurrentHashMap<String, Inventory>(this.inventoryList);
        for (Map.Entry<String, Inventory> entryOptions : tempList.entrySet()) {
            String index = entryOptions.getKey();
            Inventory inventory = entryOptions.getValue();
            String base64Inventory = this.toBase64(inventory);
            this.saveInventory(index, base64Inventory);
        }
    }

    public void removeInventory(String index) {
        if (this.inventoryList.containsKey(index)) {
            this.unsaveInventory(index);
            this.inventoryList.remove(index);
            this.plugin.getDebugger().showMessage("- Inventory Was Removed from the Inventory List \n [" + index + "]");
        }
    }

    public String toBase64(Inventory inventory) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeInt(inventory.getSize());
            this.plugin.getDebugger().showMessage("inventory size : " + inventory.getSize());
            int i = 0;
            while (i < inventory.getSize()) {
                if (inventory.getContents()[i] != null) {
                    dataOutput.writeObject((Object)inventory.getContents()[i]);
                } else {
                    dataOutput.writeObject((Object)new ItemStack(Material.AIR));
                }
                ++i;
            }
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to save item stacks.", e);
        }
    }

    public Inventory fromBase64(String data) throws IOException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            Inventory inventory = Bukkit.getServer().createInventory(null, dataInput.readInt());
            boolean check = true;
            while (check) {
                try {
                    ItemStack item = (ItemStack)dataInput.readObject();
                    if (item == null) continue;
                    inventory.addItem(new ItemStack[]{item});
                }
                catch (EOFException ex) {
                    check = false;
                }
            }
            dataInput.close();
            return inventory;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to decode class type.", e);
        }
    }

    public void dropInventoryItems(String index, Block block) {
        Location loc = new Location(block.getWorld(), (double)block.getX(), (double)block.getY(), (double)block.getZ());
        Inventory inv = this.inventoryList.get(index);
        if (inv != null) {
            ItemStack[] itemStackArray = inv.getContents();
            int n = itemStackArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack item = itemStackArray[n2];
                if (item != null) {
                    this.plugin.getDebugger().showMessage("droping + " + item.toString());
                    loc.getWorld().dropItemNaturally(loc, item);
                }
                ++n2;
            }
        }
    }
}

