/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.managers;

import com.nefilto.gravy.Core;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private Core plugin;
    private FileConfiguration gravesCfg;
    private File gravesFile;
    private FileConfiguration itemsCfg;
    private File itemsFile;
    private FileConfiguration langCfg;
    private File langFile;

    public ConfigManager(Core plugin) {
        this.plugin = plugin;
    }

    public void setup() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        this.gravesFile = new File(this.plugin.getDataFolder(), "graves.yml");
        this.itemsFile = new File(this.plugin.getDataFolder(), "items.yml");
        this.langFile = new File(this.plugin.getDataFolder(), "lang.yml");
        if (!this.gravesFile.exists()) {
            try {
                this.gravesFile.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " Could not create the graves.yml file");
            }
        }
        if (!this.itemsFile.exists()) {
            try {
                this.itemsFile.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " Could not create the items.yml file");
            }
        }
        if (!this.langFile.exists()) {
            try {
                this.langFile.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " Could not create the lang.yml file");
            }
        }
        this.gravesCfg = YamlConfiguration.loadConfiguration((File)this.gravesFile);
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.GREEN + " The graves.yml file has been loaded");
        this.itemsCfg = YamlConfiguration.loadConfiguration((File)this.itemsFile);
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.GREEN + " The items.yml file has been loaded");
        this.langCfg = YamlConfiguration.loadConfiguration((File)this.langFile);
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.GREEN + " The lang.yml file has been loaded");
    }

    public FileConfiguration getGravesCfg() {
        return this.gravesCfg;
    }

    public FileConfiguration getItemsCfg() {
        return this.itemsCfg;
    }

    public FileConfiguration getLangCfg() {
        return this.langCfg;
    }

    public void saveGraves() {
        try {
            this.gravesCfg.save(this.gravesFile);
        }
        catch (IOException e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " Could not save the graves.yml file");
        }
    }

    public void saveItems() {
        try {
            this.itemsCfg.save(this.itemsFile);
        }
        catch (IOException e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " Could not save the items.yml file");
        }
    }

    public void saveLang() {
        try {
            this.langCfg.save(this.langFile);
        }
        catch (IOException e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " Could not save the lang.yml file");
        }
    }

    public void reloadGraves() {
        this.gravesCfg = YamlConfiguration.loadConfiguration((File)this.gravesFile);
    }

    public void reloadItems() {
        this.gravesCfg = YamlConfiguration.loadConfiguration((File)this.itemsFile);
    }

    public void reloadlang() {
        this.langCfg = YamlConfiguration.loadConfiguration((File)this.langFile);
    }

    public void clearGraves() {
        try {
            this.gravesFile.createNewFile();
        }
        catch (IOException e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " Could not clear the graves.yml file");
        }
    }

    public void clearItems() {
        try {
            this.itemsFile.createNewFile();
        }
        catch (IOException e) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "]" + ChatColor.RED + " Could not clear the items.yml file");
        }
    }
}

