/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.listeners;

import com.nefilto.gravy.Core;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class TokenListener
implements Listener {
    private Core plugin;

    public TokenListener(Core plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        if (event.getRecipe() != null) {
            ItemStack itemResult = event.getRecipe().getResult();
            ItemStack[] items = event.getInventory().getContents();
            boolean backpackFound = false;
            ItemStack[] itemStackArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack i = itemStackArray[n2];
                if (!i.getType().isAir() && i != null && this.plugin.getTokenUtil().isToken(i)) {
                    backpackFound = true;
                }
                ++n2;
            }
            if (backpackFound && this.plugin.getTokenUtil().isToken(itemResult)) {
                for (HumanEntity he : event.getViewers()) {
                    Player player;
                    if (!(he instanceof Player) || (player = (Player)he).hasPermission("gravy.token.craft")) continue;
                    event.getInventory().setResult(new ItemStack(Material.AIR));
                }
            }
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (event.getRecipe() != null) {
            ItemStack[] items = event.getInventory().getContents();
            ItemStack itemResult = event.getRecipe().getResult();
            boolean backpackFound = false;
            ItemStack[] itemStackArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                ItemStack i = itemStackArray[n2];
                if (this.plugin.getTokenUtil().isToken(i)) {
                    backpackFound = true;
                }
                ++n2;
            }
            if (backpackFound && !this.plugin.getTokenUtil().isToken(itemResult)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onStarUse(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getServerVersion().contains("v1_8") || this.plugin.getServerVersion().contains("v1_7")) {
            ItemStack item = player.getInventory().getItemInHand();
            this.interactEvent(player, event, item);
        } else {
            EquipmentSlot hand = event.getHand();
            if (hand != null && hand.equals((Object)EquipmentSlot.HAND)) {
                ItemStack item = player.getInventory().getItemInMainHand();
                this.interactEvent(player, event, item);
            }
        }
    }

    private void interactEvent(Player player, PlayerInteractEvent event, ItemStack item) {
        if (item != null && this.plugin.getTokenUtil().isToken(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void clickInventory(InventoryClickEvent event) {
        ItemStack item;
        if ((event.getInventory().getType().equals((Object)InventoryType.ANVIL) || event.getInventory().getType().equals((Object)InventoryType.MERCHANT) || event.getInventory().getType().equals((Object)InventoryType.BEACON) || event.getInventory().getType().equals((Object)InventoryType.BREWING) || event.getInventory().getType().equals((Object)InventoryType.ENCHANTING) || event.getInventory().getType().equals((Object)InventoryType.FURNACE) || event.getInventory().getType().equals((Object)InventoryType.DISPENSER)) && (item = event.getCurrentItem()) != null && this.plugin.getTokenUtil().isToken(event.getCurrentItem())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDamgeEntity(EntityDamageByEntityEvent event) {
        Player player;
        LivingEntity target;
        EntityType type;
        if (this.plugin.getConfig().getBoolean("enable_token_drop") && event.getEntity() instanceof LivingEntity && !(event.getEntity() instanceof Player) && (type = (target = (LivingEntity)event.getEntity()).getType()).equals((Object)EntityType.valueOf((String)this.plugin.getConfig().getString("token_drop_mob"))) && event.getDamager() instanceof Player && (player = (Player)event.getDamager()).hasPermission("gravy.token.drop") && target.getHealth() - event.getDamage() < 1.0) {
            Random rand = new Random();
            ItemStack token = this.plugin.getTokenUtil().makeToken();
            token.setAmount(this.plugin.getConfig().getInt("token_drop_amount"));
            if (rand.nextDouble() < this.plugin.getConfig().getDouble("token_drop_chance")) {
                target.getWorld().dropItemNaturally(target.getLocation(), token);
            }
        }
    }
}

