/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.listeners;

import com.nefilto.gravy.Core;
import com.nefilto.gravy.managers.PlayerSkullsManager;
import com.nefilto.gravy.utils.Debugger;
import com.nefilto.gravy.utils.PlayerUtils;
import com.nefilto.gravy.utils.Updater;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import us.forseth11.feudal.core.Feudal;
import us.forseth11.feudal.kingdoms.Kingdom;

public class PlayerEventsListener
implements Listener {
    private Core plugin;
    private Debugger debugger;
    private PlayerSkullsManager psm;

    public PlayerEventsListener(Core plugin) {
        this.plugin = plugin;
        this.debugger = this.plugin.getDebugger();
        this.psm = this.plugin.getPlayerSkullsManager();
    }

    @EventHandler
    public void onPlayerJoin(final PlayerJoinEvent event) {
        if (event.getPlayer().hasPermission("gravy.updater")) {
            new BukkitRunnable(){

                public void run() {
                    PlayerEventsListener.this.checkUpdate(event.getPlayer());
                }
            }.runTaskLaterAsynchronously((Plugin)this.plugin, 20L);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            Kingdom pKingdom;
            Kingdom kingdom;
            Player player = event.getEntity();
            Location loc = player.getLocation();
            World world = player.getWorld();
            Location finalBlockLocation = loc;
            Location skullLocation = null;
            int exp = player.getTotalExperience();
            this.debugger.deathInfo(player);
            boolean makeGrave = true;
            if (event.getKeepInventory()) {
                makeGrave = false;
            }
            if (event.getDrops().isEmpty()) {
                makeGrave = false;
            }
            if (this.plugin.isUsingFeudal() && (kingdom = Feudal.getAPI().getKingdom(loc)) != null && (pKingdom = Feudal.getAPI().getKingdomByUUID(player.getUniqueId())) != null && !kingdom.equals(pKingdom)) {
                makeGrave = false;
            }
            if (this.plugin.getConfig().getBoolean("enable_worldguard_support") && this.plugin.isUsingWorldGuard() && !this.canBuild(player, loc)) {
                makeGrave = false;
            }
            if (this.plugin.isUsingVault() && this.plugin.getConfig().getBoolean("use_vault") && !this.plugin.getConfig().getBoolean("enable_token_use")) {
                if (player.hasPermission("gravy.money.use") && !player.hasPermission("gravy.money.nocost")) {
                    HashMap<String, String> options;
                    Economy econ = Core.getEconomy();
                    double cost = this.plugin.getConfig().getInt("grave_cost");
                    if (event.getEntity().getKiller() instanceof Player && this.plugin.getConfig().getBoolean("drop_items_on_player_kill")) {
                        makeGrave = false;
                    } else if (econ.has((OfflinePlayer)player, cost)) {
                        if (econ.hasAccount((OfflinePlayer)player)) {
                            EconomyResponse r = econ.withdrawPlayer((OfflinePlayer)player, cost);
                            if (r.transactionSuccess()) {
                                String amount = econ.format(r.amount);
                                String balance = econ.format(r.balance);
                                HashMap<String, String> options2 = new HashMap<String, String>();
                                options2.put("%%amount%%", amount);
                                options2.put("%%balance%%", balance);
                                this.plugin.getMsgsUtil().display("vault_grave_cost_subtracted_msg", player, options2);
                                makeGrave = true;
                            } else {
                                HashMap<String, String> options3 = new HashMap<String, String>();
                                options3.put("%%error%%", r.errorMessage);
                                this.plugin.getMsgsUtil().display("vault_error_msg", player, options3);
                                makeGrave = false;
                            }
                        } else {
                            options = new HashMap();
                            options.put("%%player%%", player.getName());
                            this.plugin.getMsgsUtil().display("vault_no_account_msg", player, options);
                            makeGrave = false;
                        }
                    } else {
                        options = new HashMap<String, String>();
                        options.put("%%amount%%", econ.format(cost));
                        options.put("%%balance%%", econ.format(econ.getBalance((OfflinePlayer)player)));
                        this.plugin.getMsgsUtil().display("vault_not_enough_funds_msg", player, options);
                        makeGrave = false;
                    }
                } else {
                    makeGrave = player.hasPermission("gravy.money.nocost");
                }
            }
            if (this.plugin.getConfig().getBoolean("enable_token_use") && !event.getDrops().isEmpty()) {
                if (player.hasPermission("gravy.token.use")) {
                    List items = event.getDrops();
                    if (this.plugin.getTokenUtil().containToken(items)) {
                        boolean substracted = false;
                        for (ItemStack item : items) {
                            if (item == null || !this.plugin.getTokenUtil().isToken(item)) continue;
                            if (!substracted) {
                                item.setAmount(item.getAmount() - 1);
                                substracted = true;
                                this.plugin.getMsgsUtil().display("token_consumed_msg", player);
                            }
                            if (item.getAmount() >= 0) continue;
                            item.setType(Material.AIR);
                        }
                    } else {
                        makeGrave = false;
                    }
                } else {
                    makeGrave = false;
                }
            }
            if (!(!makeGrave || !player.hasPermission("gravy.grave") || this.plugin.getDisabledWorlds().contains(world.getName()) || this.plugin.getConfig().getBoolean("drop_items_on_player_kill") && event.getEntity().getKiller() instanceof Player)) {
                Block blockAtlocation;
                if (loc.getBlockY() <= 1) {
                    finalBlockLocation = new Location(world, (double)loc.getBlockX(), (double)(loc.getBlockY() + 5), (double)loc.getBlockZ());
                }
                if ((blockAtlocation = world.getBlockAt(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())).getType().isOccluding() || blockAtlocation.getType().equals((Object)Material.WATER) || blockAtlocation.getType().equals((Object)Material.LAVA)) {
                    finalBlockLocation = new Location(world, finalBlockLocation.getX(), finalBlockLocation.getY() + 1.0, finalBlockLocation.getZ());
                }
                if (this.plugin.getConfig().getBoolean("do_safe_grave_spawn")) {
                    finalBlockLocation = this.plugin.getBlockUtils().lookForAir(finalBlockLocation);
                }
                skullLocation = finalBlockLocation.getBlock().getLocation();
                skullLocation.add(new Vector(0, 1, 0));
                this.plugin.getBlockUtils().placePlayerSkull(player, skullLocation.getBlock());
                if (world.getBlockAt(finalBlockLocation).getType().equals((Object)Material.AIR)) {
                    Material b_mat = null;
                    try {
                        b_mat = Material.getMaterial((String)this.plugin.getConfig().getString("grave_block"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (b_mat != null) {
                        world.getBlockAt(finalBlockLocation).setType(b_mat);
                    } else {
                        world.getBlockAt(finalBlockLocation).setType(Material.DIRT);
                    }
                }
                this.plugin.getPlayerSkullsManager().addSkull(player, skullLocation.getBlock());
                if (this.plugin.getConfig().getBoolean("execute_command_on_respawn")) {
                    String book = this.plugin.getConfig().getString("command_").replace("%%player%%", player.getName()).replace("%%xpos%%", String.valueOf(finalBlockLocation.getBlockX())).replace("%%ypos%%", String.valueOf(finalBlockLocation.getBlockY())).replace("%%zpos%%", String.valueOf(finalBlockLocation.getBlockZ())).replace("%%world%%", finalBlockLocation.getWorld().getName());
                    book = this.plugin.setPlaceholderAPI(book, player);
                    this.plugin.getPlayerWaitingForItem().put(player.getUniqueId(), book);
                }
                event.getDrops().clear();
            }
        }
    }

    @EventHandler
    public void onPlayerRespaw(final PlayerRespawnEvent event) {
        new BukkitRunnable(){

            public void run() {
                if (PlayerEventsListener.this.plugin.getPlayerWaitingForItem().containsKey(event.getPlayer().getUniqueId())) {
                    String command = PlayerEventsListener.this.plugin.getPlayerWaitingForItem().get(event.getPlayer().getUniqueId());
                    PlayerEventsListener.this.plugin.setPlaceholderAPI(command, event.getPlayer());
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), (String)command);
                    PlayerEventsListener.this.plugin.getDebugger().showMessage("Executing Command  : \n" + command);
                    PlayerEventsListener.this.plugin.getPlayerWaitingForItem().remove(event.getPlayer().getUniqueId());
                }
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
    }

    @EventHandler
    public void onRightClickSKull(PlayerInteractEvent event) {
        Block block;
        Player player = event.getPlayer();
        EquipmentSlot hand = event.getHand();
        if (hand != null && !player.isSneaking()) {
            if (hand.equals((Object)EquipmentSlot.HAND)) {
                this.showInfo(player, event);
            }
        } else if (hand != null && player.isSneaking() && event.getAction() == Action.RIGHT_CLICK_BLOCK && (block = event.getClickedBlock()).getType().equals((Object)Material.PLAYER_HEAD) && this.psm.containBlock(block) && this.psm.getIdFromBlock(block) != null) {
            if (player.getUniqueId().equals(this.psm.getIdFromBlock(block)) || player.hasPermission("gravy.break")) {
                Player graveOwner;
                boolean breakBlock = true;
                OfflinePlayer graveowner = Bukkit.getOfflinePlayer((UUID)this.psm.getIdFromBlock(block));
                if (Bukkit.getOnlinePlayers().contains(Bukkit.getPlayer((UUID)this.psm.getIdFromBlock(block))) && !(graveOwner = Bukkit.getPlayer((UUID)this.psm.getIdFromBlock(block))).equals(player)) {
                    breakBlock = false;
                }
                if (player.isOp()) {
                    breakBlock = true;
                }
                if (breakBlock) {
                    if (!player.getUniqueId().equals(this.psm.getIdFromBlock(block))) {
                        if (this.plugin.getConfig().getBoolean("spawn_zombie_on_not_owner_break")) {
                            PlayerUtils.spawnZombie(block, player, this.plugin);
                        }
                    } else if (this.plugin.getConfig().getBoolean("spawn_zombie_on_owner_break")) {
                        PlayerUtils.spawnZombie(block, player, this.plugin);
                    }
                    Block blockunder = block.getWorld().getBlockAt(block.getLocation().subtract(0.0, 2.0, 0.0));
                    Block blockDirt = block.getWorld().getBlockAt(block.getLocation().subtract(0.0, 1.0, 0.0));
                    if (blockunder.getType().equals((Object)Material.LAVA) || blockunder.getType().equals((Object)Material.AIR)) {
                        block.setType(Material.AIR);
                    } else {
                        block.setType(Material.AIR);
                        if (blockDirt.getType().equals((Object)Material.DIRT) || blockDirt.getType().equals((Object)Material.GRASS)) {
                            blockDirt.setType(Material.AIR);
                        }
                    }
                    this.plugin.getPlayerInventoryManager().dropInventoryItems(this.psm.stringify(graveowner.getUniqueId(), block), block);
                    this.psm.removeSkull(this.psm.stringify(graveowner.getUniqueId(), block));
                    this.plugin.getMsgsUtil().display("breaking_grave_msg", player);
                    if (this.plugin.getConfig().getBoolean("execute_command_on_grave_break")) {
                        String command = this.plugin.getConfig().getString("command_on_grave_break").replace("%%player%%", player.getName()).replace("%%xpos%%", String.valueOf(block.getX())).replace("%%ypos%%", String.valueOf(block.getY())).replace("%%zpos%%", String.valueOf(block.getZ())).replace("%%world%%", block.getWorld().getName());
                        command = this.plugin.setPlaceholderAPI(command, player);
                        this.plugin.setPlaceholderAPI(command, player);
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), (String)command);
                    }
                } else {
                    event.setCancelled(true);
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 100, 1));
                    player.playSound(player.getLocation(), Sound.ENTITY_GHAST_DEATH, 10.0f, 1.0f);
                    this.plugin.getMsgsUtil().display("protected_grave_msg", player);
                }
            } else {
                event.setCancelled(true);
            }
        }
    }

    private void showInfo(Player player, PlayerInteractEvent event) {
        Block block;
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && (block = event.getClickedBlock()).getType().equals((Object)Material.PLAYER_HEAD) && this.psm.containBlock(block) && this.psm.getIdFromBlock(block) != null && player.hasPermission("gravy.info")) {
            OfflinePlayer graveowner = Bukkit.getOfflinePlayer((UUID)this.psm.getIdFromBlock(block));
            int timer = this.psm.getBlockTime(block);
            int hours = (timer /= 20) / 3600;
            int remainder = timer - hours * 3600;
            int mins = remainder / 60;
            int secs = remainder -= mins * 60;
            HashMap<String, String> options = new HashMap<String, String>();
            String graveOwner = graveowner.getName();
            String time = String.valueOf(hours) + "h" + mins + "m" + secs + "s";
            options.put("%%grave_owner%%", graveOwner);
            options.put("%%time%%", time);
            options.put("%%hours%%", Integer.toString(hours));
            options.put("%%minutes%%", Integer.toString(mins));
            options.put("%%seconds%%", Integer.toString(secs));
            this.plugin.getMsgsUtil().display("grave_right_click_msg", player, options);
            event.setCancelled(true);
        }
    }

    private void checkUpdate(Player player) {
        Updater.UpdateResult result = this.plugin.getUpdater().getResult();
        String updateUrl = this.plugin.getUpdateLink();
        switch (result) {
            case FAIL_SPIGOT: {
                this.plugin.getChatUtil().sendMessage(player, ChatColor.RED + "gravy Can't Check for update");
                break;
            }
            case NO_UPDATE: {
                break;
            }
            case UPDATE_AVAILABLE: {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("%url%", updateUrl);
                options.put("%version%", this.plugin.getUpdater().getVersion());
                this.plugin.getMsgsUtil().display("update_available_msg", player, options);
                break;
            }
        }
    }

    public boolean canBuild(Player p, Location l) {
        RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)l);
        return query.testState(loc, WorldGuardPlugin.inst().wrapPlayer(p), new StateFlag[]{Flags.BUILD});
    }
}

