/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.listeners;

import com.nefilto.gravy.Core;
import com.nefilto.gravy.managers.PlayerInventoryManager;
import com.nefilto.gravy.managers.PlayerSkullsManager;
import com.nefilto.gravy.utils.PlayerUtils;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BlockEventsListener
implements Listener {
    private Core plugin;
    private PlayerSkullsManager psm;
    private PlayerInventoryManager pim;

    public BlockEventsListener(Core plugin) {
        this.plugin = plugin;
        this.psm = this.plugin.getPlayerSkullsManager();
        this.pim = this.plugin.getPlayerInventoryManager();
    }

    @EventHandler
    public void onBlockExplode(BlockExplodeEvent event) {
        List blocksAffected = event.blockList();
        for (Block block : blocksAffected) {
            if (!block.getType().equals((Object)Material.PLAYER_HEAD) || !this.psm.containBlock(block)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (block.getType().equals((Object)Material.PLAYER_HEAD) && this.psm.containBlock(block) && this.psm.getIdFromBlock(block) != null) {
            if (player.getUniqueId().equals(this.psm.getIdFromBlock(block)) || player.hasPermission("gravy.break")) {
                Player graveOwner;
                boolean breakBlock = true;
                OfflinePlayer graveowner = Bukkit.getOfflinePlayer((UUID)this.psm.getIdFromBlock(block));
                if (Bukkit.getOnlinePlayers().contains(Bukkit.getPlayer((UUID)this.psm.getIdFromBlock(block))) && !(graveOwner = Bukkit.getPlayer((UUID)this.psm.getIdFromBlock(block))).equals(player) && graveOwner.hasPermission("grave.protected")) {
                    breakBlock = false;
                }
                if (player.isOp()) {
                    breakBlock = true;
                }
                if (breakBlock) {
                    if (!player.getUniqueId().equals(this.psm.getIdFromBlock(block))) {
                        if (this.plugin.getConfig().getBoolean("spawn_zombie_on_not_owner_break")) {
                            PlayerUtils.spawnZombie(block, player, this.plugin);
                        }
                    } else if (this.plugin.getConfig().getBoolean("spawn_zombie_on_owner_break")) {
                        PlayerUtils.spawnZombie(block, player, this.plugin);
                    }
                    event.getBlock().getDrops().clear();
                    Block blockunder = event.getBlock().getWorld().getBlockAt(event.getBlock().getLocation().subtract(0.0, 2.0, 0.0));
                    Block blockDirt = event.getBlock().getWorld().getBlockAt(event.getBlock().getLocation().subtract(0.0, 1.0, 0.0));
                    if (blockunder.getType().equals((Object)Material.LAVA)) {
                        event.getBlock().setType(Material.AIR);
                    } else {
                        event.getBlock().setType(Material.AIR);
                        if (blockDirt.getType().equals((Object)Material.DIRT) || blockDirt.getType().equals((Object)Material.GRASS)) {
                            blockDirt.setType(Material.AIR);
                        }
                    }
                    this.pim.dropInventoryItems(this.psm.stringify(graveowner.getUniqueId(), block), block);
                    this.psm.removeSkull(this.psm.stringify(graveowner.getUniqueId(), block));
                    this.plugin.getMsgsUtil().display("breaking_grave_msg", player);
                    if (this.plugin.getConfig().getBoolean("execute_command_on_grave_break")) {
                        String command = this.plugin.getConfig().getString("command_on_grave_break").replace("%%player%%", player.getName()).replace("%%xpos%%", String.valueOf(block.getX())).replace("%%ypos%%", String.valueOf(block.getY())).replace("%%zpos%%", String.valueOf(block.getZ())).replace("%%world%%", block.getWorld().getName());
                        command = this.plugin.setPlaceholderAPI(command, player);
                        this.plugin.setPlaceholderAPI(command, player);
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), (String)command);
                    }
                } else {
                    event.setCancelled(true);
                    player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 100, 1));
                    player.playSound(player.getLocation(), Sound.ENTITY_GHAST_DEATH, 10.0f, 1.0f);
                    this.plugin.getMsgsUtil().display("protected_grave_msg", player);
                }
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPistonPushBlock(BlockPistonExtendEvent event) {
        if (!event.getBlocks().isEmpty()) {
            List blocks = event.getBlocks();
            for (Block block : blocks) {
                if (!block.getType().equals((Object)Material.PLAYER_HEAD) || !this.psm.containBlock(block)) continue;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        Block block = event.getToBlock();
        if (this.psm.containBlock(block)) {
            event.setCancelled(true);
        }
    }
}

