/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.inventories;

import com.nefilto.gravy.Core;
import com.nefilto.gravy.inventories.InventoryGui;
import com.nefilto.gravy.utils.DeathPointUtil;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RecoverGraveInventory
extends InventoryGui {
    private Player player;
    private List<Block> graves;
    private DeathPointUtil dt;

    public RecoverGraveInventory(Core plugin, Player player) {
        super(plugin);
        this.player = player;
        this.dt = new DeathPointUtil(plugin);
        this.graves = plugin.getPlayerSkullsManager().getPlayerBlocks(this.player);
        this.inventorySize = this.sizeFromItems(this.graves.size());
        this.inventoryName = ChatColor.GOLD + player.getName() + "'s GRAVES";
        this.inventory = Bukkit.createInventory(null, (int)this.inventorySize, (String)this.inventoryName);
        this.populate();
        this.setItems();
    }

    private void setItems() {
        Location loc = null;
        int i = 0;
        while (i < this.graves.size()) {
            Block block = this.graves.get(i);
            loc = block.getLocation();
            World world = block.getWorld();
            ItemStack item = this.dt.makeDeathPoint(world, loc, block);
            if (i < this.inventorySize) {
                this.inventory.setItem(i, item);
            }
            ++i;
        }
    }
}

