/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.inventories;

import com.nefilto.gravy.Core;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryGui {
    protected Inventory inventory;
    protected int inventorySize;
    protected Core plugin;
    protected String inventoryName;

    public InventoryGui(Core plugin, int size) {
        this.plugin = plugin;
        this.inventorySize = size;
        this.inventoryName = ChatColor.GOLD + "AdminRod GUI";
        this.inventory = Bukkit.createInventory(null, (int)this.inventorySize, (String)this.inventoryName);
        this.populate();
    }

    public InventoryGui(Core plugin) {
        this(plugin, 54);
    }

    protected void populate() {
        ItemStack pane = new ItemStack(Material.WHITE_STAINED_GLASS_PANE);
        ItemMeta im = pane.getItemMeta();
        im.setDisplayName(" ");
        pane.setItemMeta(im);
        int i = 0;
        while (i < this.inventorySize) {
            this.inventory.setItem(i, pane);
            ++i;
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public String getInventoryName() {
        return this.inventoryName;
    }

    public int sizeFromItems(int nbr) {
        int size = 54;
        if (nbr < 10) {
            return 9;
        }
        if (nbr >= 10 && nbr < 19) {
            return 18;
        }
        if (nbr >= 19 && nbr < 28) {
            return 27;
        }
        if (nbr >= 28 && nbr < 37) {
            return 36;
        }
        if (nbr >= 37 && nbr < 46) {
            return 45;
        }
        if (nbr >= 46 && nbr < 54) {
            return 54;
        }
        return size;
    }
}

