/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy.commands;

import com.nefilto.gravy.Core;
import com.nefilto.gravy.inventories.RecoverGraveInventory;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RootPluginCommand
implements CommandExecutor {
    private Core plugin;

    public RootPluginCommand(Core plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            Player p;
            Player player = (Player)sender;
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("reload") && player.hasPermission("gravy.reload")) {
                    this.plugin.reloadConfig();
                    this.plugin.getDisabledWorlds().clear();
                    if (this.plugin.getConfig().isSet("disabled_worlds")) {
                        List bannedworlds = this.plugin.getConfig().getStringList("disabled_worlds");
                        this.plugin.getDisabledWorlds().addAll(bannedworlds);
                    }
                    this.plugin.getCfgm().reloadlang();
                    this.plugin.getMsgsUtil().loadMsgs();
                    sender.sendMessage(ChatColor.GREEN + ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "] Configuration Reloaded!");
                }
                if (args[0].equalsIgnoreCase("list") && player.hasPermission("gravy.list")) {
                    List<Block> graves = this.plugin.getPlayerSkullsManager().getPlayerBlocks(player);
                    for (Block block : graves) {
                        int timer = this.plugin.getPlayerSkullsManager().getBlockTime(block);
                        int hours = (timer /= 20) / 3600;
                        int remainder = timer - hours * 3600;
                        int mins = remainder / 60;
                        int secs = remainder -= mins * 60;
                        String world = block.getWorld().getName();
                        String x = Integer.toString(block.getLocation().getBlockX());
                        String y = Integer.toString(block.getLocation().getBlockY());
                        String z = Integer.toString(block.getLocation().getBlockZ());
                        String time = String.valueOf(hours) + "h" + mins + "m" + secs + "s";
                        world = this.plugin.getChatUtil().getWorldAlias(world);
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("%%world%%", world);
                        options.put("%%xpos%%", x);
                        options.put("%%ypos%%", y);
                        options.put("%%zpos%%", z);
                        options.put("%%time%%", time);
                        options.put("%%hours%%", Integer.toString(hours));
                        options.put("%%minutes%%", Integer.toString(mins));
                        options.put("%%seconds%%", Integer.toString(secs));
                        this.plugin.getMsgsUtil().display("list_graves_msg", player, options);
                    }
                    if (graves.isEmpty()) {
                        this.plugin.getMsgsUtil().display("graves_not_found_msg", player);
                    }
                }
                if (args[0].equalsIgnoreCase("recover") && player.hasPermission("gravy.recover")) {
                    if (!this.plugin.getPlayerSkullsManager().getPlayerBlocks(player).isEmpty()) {
                        RecoverGraveInventory ri = new RecoverGraveInventory(this.plugin, player);
                        player.openInventory(ri.getInventory());
                    } else {
                        this.plugin.getMsgsUtil().display("graves_not_found_msg", player);
                    }
                }
                if (args[0].equalsIgnoreCase("permission") && player.hasPermission("gravy.permission")) {
                    this.plugin.getChatUtil().sendMessage(player, this.plugin.getChatUtil().getHR());
                    this.plugin.getChatUtil().spacer(player, 1);
                    this.plugin.getChatUtil().sendCenteredMessage(player, "&l&nGravy Permissions");
                    this.plugin.getChatUtil().spacer(player, 2);
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.reload]: " + ChatColor.RESET + "use" + ChatColor.YELLOW + " /gravy reload");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.updater]: " + ChatColor.RESET + "see the update link in chat");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.list]: " + ChatColor.RESET + "use" + ChatColor.YELLOW + " /gravy list");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.worlds.disable]: " + ChatColor.RESET + "use" + ChatColor.YELLOW + " /gravy disable <world>");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.worlds.enable]: " + ChatColor.RESET + "use" + ChatColor.YELLOW + " /gravy enable <world>");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.worlds.list]: " + ChatColor.RESET + "use" + ChatColor.YELLOW + " /gravy worlds");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.list.player]: " + ChatColor.RESET + "use" + ChatColor.YELLOW + " /gravy list <player>");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.token.give]: " + ChatColor.RESET + "use" + ChatColor.YELLOW + " /gravy give <player> token");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.token.craft]: " + ChatColor.RESET + "let a player craft the token");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.token.use]: " + ChatColor.RESET + "let a player use the gravy token");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.token.drop]: " + ChatColor.RESET + "player can drop the token");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.recover]: " + ChatColor.RESET + "use" + ChatColor.YELLOW + " /gravy recover");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.permission]: " + ChatColor.RESET + "use" + ChatColor.YELLOW + " /gravy permission");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.grave]: " + ChatColor.RESET + "spawn a grave when the player die");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.info]: " + ChatColor.RESET + "let you see a grave infos");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.break]: " + ChatColor.RESET + "break any grave");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.protected]: " + ChatColor.RESET + "players can't break your grave");
                    this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.notimer]: " + ChatColor.RESET + "infinite grave timer");
                    this.plugin.getChatUtil().spacer(player, 1);
                    this.plugin.getChatUtil().sendMessage(player, this.plugin.getChatUtil().getHR());
                }
                if (args[0].equalsIgnoreCase("help") && player.hasPermission("gravy.help")) {
                    this.plugin.getChatUtil().sendMessage(player, this.plugin.getChatUtil().getHR());
                    this.plugin.getChatUtil().spacer(player, 1);
                    this.plugin.getChatUtil().sendCenteredMessage(player, "&l&nGravy Commands");
                    this.plugin.getChatUtil().spacer(player, 2);
                    if (player.hasPermission("gravy.reload")) {
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.YELLOW + "/gravy reload");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.RESET + "reload config-" + ChatColor.DARK_GREEN + "[gravy.reload]");
                        this.plugin.getChatUtil().spacer(player, 1);
                    }
                    if (player.hasPermission("gravy.list")) {
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.YELLOW + "/gravy list");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.RESET + "List the Player Graves-" + ChatColor.DARK_GREEN + "[gravy.list]");
                        this.plugin.getChatUtil().spacer(player, 1);
                    }
                    if (player.hasPermission("gravy.worlds.disable")) {
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.YELLOW + "/gravy disable <world_name>");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.RESET + "Disable the gaves in a World-" + ChatColor.DARK_GREEN + "[gravy.worlds.disable]");
                        this.plugin.getChatUtil().spacer(player, 1);
                    }
                    if (player.hasPermission("gravy.worlds.enable")) {
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.YELLOW + "/gravy enable <world_name>");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.RESET + "Enable the gaves in a World-" + ChatColor.DARK_GREEN + "[gravy.worlds.enable]");
                        this.plugin.getChatUtil().spacer(player, 1);
                    }
                    if (player.hasPermission("gravy.worlds.list")) {
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.YELLOW + "/gravy worlds");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.RESET + "Worlds that have graves disabled-" + ChatColor.DARK_GREEN + "[gravy.worlds.list]");
                        this.plugin.getChatUtil().spacer(player, 1);
                    }
                    if (player.hasPermission("gravy.list.player")) {
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.YELLOW + "/gravy list <player>");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.RESET + "List A Player graves-" + ChatColor.DARK_GREEN + "[gravy.list.player]");
                        this.plugin.getChatUtil().spacer(player, 1);
                    }
                    if (player.hasPermission("gravy.token.give")) {
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.YELLOW + "/gravy give <player> token");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.RESET + "Give a [gravy token]-" + ChatColor.DARK_GREEN + "[gravy.token.give]");
                        this.plugin.getChatUtil().spacer(player, 1);
                    }
                    if (player.hasPermission("gravy.token.give")) {
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.YELLOW + "/gravy give <player> token <amount>");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.RESET + "Give <amount> of [gravy token]-" + ChatColor.DARK_GREEN + "[gravy.token.give]");
                        this.plugin.getChatUtil().spacer(player, 1);
                    }
                    if (player.hasPermission("gravy.recover")) {
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.YELLOW + "/gravy recover");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.RESET + "Teleport The Player To His Grave-" + ChatColor.DARK_GREEN + "[gravy.recover]");
                        this.plugin.getChatUtil().spacer(player, 1);
                    }
                    if (player.hasPermission("gravy.recover.player")) {
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.YELLOW + "/gravy recover <player>");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.RESET + "Teleport A Player To Grave Location");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.DARK_GREEN + "[gravy.recover.player]");
                        this.plugin.getChatUtil().spacer(player, 1);
                    }
                    if (player.hasPermission("gravy.permission")) {
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.YELLOW + "/gravy permission");
                        this.plugin.getChatUtil().sendCenteredMessage(player, ChatColor.RESET + "List The Plugin Permissions-" + ChatColor.DARK_GREEN + "[gravy.permission]");
                        this.plugin.getChatUtil().spacer(player, 1);
                    }
                    this.plugin.getChatUtil().sendMessage(player, this.plugin.getChatUtil().getHR());
                }
                if (args[0].equalsIgnoreCase("worlds") && player.hasPermission("gravy.worlds.list")) {
                    player.sendMessage(ChatColor.YELLOW + "Worlds List :");
                    for (World world : Bukkit.getWorlds()) {
                        if (this.plugin.getDisabledWorlds().contains(world.getName())) {
                            player.sendMessage(ChatColor.RED + "[DISABLED] " + ChatColor.RESET + world.getName());
                            continue;
                        }
                        player.sendMessage(ChatColor.GREEN + "[ENABLED] " + ChatColor.RESET + world.getName());
                    }
                }
            }
            if (args.length == 2) {
                HashMap<String, String> options;
                if (args[0].equalsIgnoreCase("list") && player.hasPermission("gravy.list.player") && args[1] != null && args[1] != "") {
                    if (Bukkit.getPlayer((String)args[1]) != null) {
                        Player playerToList = Bukkit.getPlayer((String)args[1]);
                        List<Block> list = this.plugin.getPlayerSkullsManager().getPlayerBlocks(playerToList);
                        for (Block block : list) {
                            int timer = this.plugin.getPlayerSkullsManager().getBlockTime(block);
                            int hours = (timer /= 20) / 3600;
                            int remainder = timer - hours * 3600;
                            int mins = remainder / 60;
                            int secs = remainder -= mins * 60;
                            String world = block.getWorld().getName();
                            String x = Integer.toString(block.getLocation().getBlockX());
                            String y = Integer.toString(block.getLocation().getBlockY());
                            String z = Integer.toString(block.getLocation().getBlockZ());
                            String time = String.valueOf(hours) + "h" + mins + "m" + secs + "s";
                            world = this.plugin.getChatUtil().getWorldAlias(world);
                            HashMap<String, String> options2 = new HashMap<String, String>();
                            options2.put("%%world%%", world);
                            options2.put("%%xpos%%", x);
                            options2.put("%%ypos%%", y);
                            options2.put("%%zpos%%", z);
                            options2.put("%%time%%", time);
                            options2.put("%%hours%%", Integer.toString(hours));
                            options2.put("%%minutes%%", Integer.toString(mins));
                            options2.put("%%seconds%%", Integer.toString(secs));
                            this.plugin.getMsgsUtil().display("list_graves_msg", player, options2);
                        }
                        if (list.isEmpty()) {
                            this.plugin.getMsgsUtil().display("graves_not_found_msg", player);
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + " Player doesn't exist or Offline");
                    }
                }
                if (args[0].equalsIgnoreCase("recover") && player.hasPermission("gravy.recover.player") && args[1] != null && args[1] != "") {
                    if (Bukkit.getPlayer((String)args[1]) != null) {
                        Player playerToRecover = Bukkit.getPlayer((String)args[1]);
                        if (!this.plugin.getPlayerSkullsManager().getPlayerBlocks(player).isEmpty()) {
                            RecoverGraveInventory recoverGraveInventory = new RecoverGraveInventory(this.plugin, playerToRecover);
                            playerToRecover.openInventory(recoverGraveInventory.getInventory());
                        } else {
                            this.plugin.getMsgsUtil().display("graves_not_found_msg", player);
                        }
                    } else {
                        player.sendMessage(ChatColor.RED + " Player doesn't exist or Offline");
                    }
                }
                if (args[0].equalsIgnoreCase("disable") && player.hasPermission("gravy.disable") && args[1] != null && args[1] != "") {
                    options = new HashMap<String, String>();
                    String string = args[1].toLowerCase();
                    options.put("%%world%%", string);
                    if (Bukkit.getWorld((String)string) != null) {
                        if (!this.plugin.getDisabledWorlds().contains(string)) {
                            this.plugin.getDisabledWorlds().add(string);
                            this.plugin.getMsgsUtil().display("world_disabled_msg", player, options);
                            this.plugin.saveDisabledWorlds();
                        } else {
                            this.plugin.getMsgsUtil().display("world_already_disabled_msg", player, options);
                        }
                    } else {
                        this.plugin.getMsgsUtil().display("invalid_world_msg", player, options);
                    }
                }
                if (args[0].equalsIgnoreCase("enable") && player.hasPermission("gravy.enable") && args[1] != null && args[1] != "") {
                    options = new HashMap();
                    String string = args[1].toLowerCase();
                    options.put("%%world%%", string);
                    if (Bukkit.getWorld((String)string) != null) {
                        if (this.plugin.getDisabledWorlds().contains(string)) {
                            this.plugin.getDisabledWorlds().remove(string);
                            this.plugin.getMsgsUtil().display("world_enable_msg", player, options);
                            this.plugin.saveDisabledWorlds();
                        } else {
                            this.plugin.getMsgsUtil().display("world_already_enabled_msg", player, options);
                        }
                    } else {
                        this.plugin.getMsgsUtil().display("invalid_world_msg", player, options);
                    }
                }
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("give") && player.hasPermission("gravy.token.give") && args[1] != null && args[1] != "" && Bukkit.getPlayer((String)args[1]) != null) {
                p = Bukkit.getPlayer((String)args[1]);
                if (args[2] != null && args[2].equalsIgnoreCase("token")) {
                    ItemStack itemStack = this.plugin.getTokenUtil().makeToken();
                    if (p.getInventory().firstEmpty() != -1) {
                        p.getInventory().addItem(new ItemStack[]{itemStack});
                    } else {
                        this.plugin.getMsgsUtil().display("inventory_full_msg", p);
                    }
                }
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("give") && player.hasPermission("gravy.token.give") && args[1] != null && args[1] != "" && Bukkit.getPlayer((String)args[1]) != null) {
                p = Bukkit.getPlayer((String)args[1]);
                if (args[2] != null && args[2].equalsIgnoreCase("token")) {
                    ItemStack itemStack = this.plugin.getTokenUtil().makeToken();
                    if (args[3] != null && StringUtils.isNumeric((String)args[3])) {
                        int amount = Integer.parseInt(args[3]);
                        itemStack.setAmount(amount);
                    }
                    if (p.getInventory().firstEmpty() != -1) {
                        p.getInventory().addItem(new ItemStack[]{itemStack});
                    } else {
                        this.plugin.getMsgsUtil().display("inventory_full_msg", p);
                    }
                }
            }
        } else if (!(sender instanceof Player)) {
            ItemStack token;
            Player p;
            if (args.length == 1 && args[0].equalsIgnoreCase("reload") && sender.hasPermission("gravy.reload")) {
                this.plugin.reloadConfig();
                this.plugin.getDisabledWorlds().clear();
                if (this.plugin.getConfig().isSet("disabled_worlds")) {
                    List bannedworlds = this.plugin.getConfig().getStringList("disabled_worlds");
                    this.plugin.getDisabledWorlds().addAll(bannedworlds);
                }
                this.plugin.getCfgm().reloadlang();
                this.plugin.getMsgsUtil().loadMsgs();
                Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.GREEN + ChatColor.AQUA + "[" + this.plugin.getDescription().getName() + " " + this.plugin.getDescription().getVersion() + "] Configuration Reloaded!");
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("give") && args[1] != null && args[1] != "" && Bukkit.getPlayer((String)args[1]) != null) {
                p = Bukkit.getPlayer((String)args[1]);
                if (args[2] != null && args[2].equalsIgnoreCase("token")) {
                    token = this.plugin.getTokenUtil().makeToken();
                    if (p.getInventory().firstEmpty() != -1) {
                        p.getInventory().addItem(new ItemStack[]{token});
                    } else {
                        this.plugin.getMsgsUtil().display("inventory_full_msg", p);
                    }
                }
            }
            if (args.length == 4 && args[0].equalsIgnoreCase("give") && sender.hasPermission("gravy.token.give") && args[1] != null && args[1] != "" && Bukkit.getPlayer((String)args[1]) != null) {
                p = Bukkit.getPlayer((String)args[1]);
                if (args[2] != null && args[2].equalsIgnoreCase("token")) {
                    token = this.plugin.getTokenUtil().makeToken();
                    if (args[3] != null && StringUtils.isNumeric((String)args[3])) {
                        int n = Integer.parseInt(args[3]);
                        token.setAmount(n);
                    }
                    if (p.getInventory().firstEmpty() != -1) {
                        p.getInventory().addItem(new ItemStack[]{token});
                    } else {
                        this.plugin.getMsgsUtil().display("inventory_full_msg", p);
                    }
                }
            }
        } else {
            return false;
        }
        return true;
    }
}

