/*
 * Decompiled with CFR 0.152.
 */
package com.nefilto.gravy;

import com.nefilto.gravy.commands.RootPluginCommand;
import com.nefilto.gravy.crafting.TokenRecipe;
import com.nefilto.gravy.listeners.BlockEventsListener;
import com.nefilto.gravy.listeners.EntityEventsListener;
import com.nefilto.gravy.listeners.PlayerEventsListener;
import com.nefilto.gravy.listeners.TokenListener;
import com.nefilto.gravy.listeners.gui.RecoverGraveGuiListener;
import com.nefilto.gravy.managers.ConfigManager;
import com.nefilto.gravy.managers.PlayerInventoryManager;
import com.nefilto.gravy.managers.PlayerSkullsManager;
import com.nefilto.gravy.tasks.SaveToConfigTask;
import com.nefilto.gravy.tasks.WatchGarvesTask;
import com.nefilto.gravy.utils.BlockUtils;
import com.nefilto.gravy.utils.ChatUtil;
import com.nefilto.gravy.utils.Debugger;
import com.nefilto.gravy.utils.Messages;
import com.nefilto.gravy.utils.Metrics;
import com.nefilto.gravy.utils.PlayerUtils;
import com.nefilto.gravy.utils.ReflexionUtils;
import com.nefilto.gravy.utils.TokenUtil;
import com.nefilto.gravy.utils.Updater;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Core
extends JavaPlugin {
    private ConfigManager cfgm;
    private FileConfiguration config = this.getConfig();
    private final int RESOURCE_ID = 45288;
    private final String UPDATE_LINK = "https://www.spigotmc.org/resources/gravy.45288/";
    private Updater updater;
    private Debugger debugger;
    private BlockUtils blockUtils;
    private PlayerUtils playerUtils;
    private ReflexionUtils reflexionUtils;
    private PlayerSkullsManager playerSkullsManager;
    private PlayerInventoryManager playerInventoryManager;
    private HashMap<UUID, String> playerWaitingForItem;
    private WatchGarvesTask watchGravesTask;
    private SaveToConfigTask saveToConfig;
    private ChatUtil chatUtil;
    private Messages msgsUtil;
    private List<String> disabledWorlds;
    private TokenUtil tokenUtil;
    private TokenRecipe tokenRecipe;
    private static Economy econ = null;
    private static Permission perms = null;
    private static Chat chat = null;

    public PlayerInventoryManager getPlayerInventoryManager() {
        return this.playerInventoryManager;
    }

    public void onEnable() {
        this.loadConfig();
        this.loadConfigManager();
        this.debugger = new Debugger(this);
        this.blockUtils = new BlockUtils(this);
        this.playerUtils = new PlayerUtils(this);
        this.playerWaitingForItem = new HashMap();
        this.disabledWorlds = new ArrayList<String>();
        if (this.getConfig().isSet("disabled_worlds")) {
            List bannedworlds;
            this.disabledWorlds = bannedworlds = this.getConfig().getStringList("disabled_worlds");
        }
        this.playerSkullsManager = new PlayerSkullsManager(this);
        this.playerInventoryManager = new PlayerInventoryManager(this);
        this.playerSkullsManager.loadSkulls();
        try {
            this.playerInventoryManager.loadInventory();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.chatUtil = new ChatUtil(this);
        this.reflexionUtils = new ReflexionUtils();
        this.msgsUtil = new Messages(this);
        this.tokenUtil = new TokenUtil(this);
        this.tokenRecipe = new TokenRecipe(this);
        if (this.getConfig().getBoolean("enable_token_craft")) {
            this.tokenRecipe.customRecipe();
        }
        this.watchGravesTask = new WatchGarvesTask(this);
        if (this.getConfig().getBoolean("enable_timer")) {
            this.watchGravesTask.runTaskTimer((Plugin)this, 0L, 20L);
        }
        this.saveToConfig = new SaveToConfigTask(this);
        this.saveToConfig.runTaskTimerAsynchronously((Plugin)this, 0L, this.getConfig().getInt("save_timer") * 20);
        this.updater = new Updater(this, 45288, false);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEventsListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockEventsListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityEventsListener(this), (Plugin)this);
        if (this.getConfig().getBoolean("enable_token_use")) {
            this.getServer().getPluginManager().registerEvents((Listener)new TokenListener(this), (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new RecoverGraveGuiListener(this), (Plugin)this);
        this.getCommand("gravy").setExecutor((CommandExecutor)new RootPluginCommand(this));
        Metrics metrics = new Metrics(this);
        if (this.isUsingFeudal()) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.getDescription().getName() + " " + this.getDescription().getVersion() + "]" + ChatColor.GREEN + " Feudal Detected!");
        }
        if (this.isUsingWorldGuard()) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.getDescription().getName() + " " + this.getDescription().getVersion() + "]" + ChatColor.GREEN + " WorldGuard Detected!");
        }
        if (this.isUsingWorldEdit()) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.getDescription().getName() + " " + this.getDescription().getVersion() + "]" + ChatColor.GREEN + " WorldEdit Detected!");
        }
        if (this.isUsingVault()) {
            Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.getDescription().getName() + " " + this.getDescription().getVersion() + "]" + ChatColor.GREEN + " Vault Detected!");
            this.setupEconomy();
            this.setupPermissions();
            this.setupChat();
        }
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.getDescription().getName() + " " + this.getDescription().getVersion() + "]" + ChatColor.GREEN + " Gravy Loaded");
    }

    public HashMap<UUID, String> getPlayerWaitingForItem() {
        return this.playerWaitingForItem;
    }

    public PlayerSkullsManager getPlayerSkullsManager() {
        return this.playerSkullsManager;
    }

    public PlayerUtils getPlayerUtils() {
        return this.playerUtils;
    }

    public BlockUtils getBlockUtils() {
        return this.blockUtils;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public void onDisable() {
        this.getPlayerSkullsManager().saveToConfig();
        this.getPlayerInventoryManager().saveToConfig();
        this.saveDisabledWorlds();
        this.getDisabledWorlds().clear();
        Bukkit.getServer().getConsoleSender().sendMessage(ChatColor.AQUA + "[" + this.getDescription().getName() + " " + this.getDescription().getVersion() + "]" + ChatColor.RED + " Gravy Unloaded");
    }

    private void loadConfigManager() {
        this.cfgm = new ConfigManager(this);
        this.cfgm.setup();
    }

    private void loadConfig() {
        File file = new File(this.getDataFolder() + File.separator + "config.yml");
        if (!file.exists()) {
            this.getConfig().addDefault("debug_mode", (Object)false);
            this.getConfig().addDefault("enable_chat_prefix", (Object)true);
            this.getConfig().addDefault("chat_line_color", (Object)"&2");
            this.getConfig().addDefault("do_safe_grave_spawn", (Object)true);
            this.getConfig().addDefault("save_timer", (Object)60);
            this.getConfig().addDefault("grave_timer", (Object)1200);
            this.getConfig().addDefault("enable_timer", (Object)true);
            this.getConfig().addDefault("grave_block", (Object)"DIRT");
            this.getConfig().addDefault("spawn_zombie_on_not_owner_break", (Object)true);
            this.getConfig().addDefault("spawn_zombie_on_owner_break", (Object)false);
            this.getConfig().addDefault("zombie_hp", (Object)20);
            this.getConfig().addDefault("can_zombie_pickup_items", (Object)true);
            this.getConfig().addDefault("execute_command_on_respawn", (Object)false);
            this.getConfig().addDefault("execute_command_on_grave_break", (Object)false);
            this.getConfig().addDefault("command_", (Object)"");
            this.getConfig().addDefault("command_on_grave_break", (Object)"");
            this.getConfig().addDefault("drop_items_on_player_kill", (Object)false);
            this.getConfig().addDefault("enable_token_use", (Object)true);
            this.getConfig().addDefault("enable_token_craft", (Object)true);
            this.getConfig().addDefault("enable_token_drop", (Object)true);
            this.getConfig().addDefault("token_drop_mob", (Object)"GHAST");
            this.getConfig().addDefault("token_drop_amount", (Object)1);
            this.getConfig().addDefault("token_drop_chance", (Object)0.05);
            this.getConfig().addDefault("token_item", (Object)"MAGMA_CREAM");
            this.getConfig().addDefault("token_craft_recipe", (Object)"GOLD_INGOT:GOLD_INGOT:GOLD_INGOT-GOLD_INGOT:DIAMOND:GOLD_INGOT-GOLD_INGOT:CHEST:GOLD_INGOT");
            this.getConfig().addDefault("use_vault", (Object)false);
            this.getConfig().addDefault("grave_cost", (Object)500);
            this.getConfig().addDefault("enable_worldguard_support", (Object)true);
            ArrayList<String> bannedworlds = new ArrayList<String>();
            bannedworlds.add("change_me");
            this.getConfig().addDefault("disabled_worlds", bannedworlds);
            ArrayList<String> worldAliases = new ArrayList<String>();
            worldAliases.add("world::The Overworld");
            worldAliases.add("world_nether::The Nether");
            worldAliases.add("world_the_end::The End");
            this.getConfig().addDefault("worlds_aliases", worldAliases);
            this.getConfig().options().copyDefaults(true);
            this.saveConfig();
        } else {
            this.reloadConfig();
        }
    }

    public void saveDisabledWorlds() {
        this.reloadConfig();
        if (this.disabledWorlds.isEmpty()) {
            if (this.getConfig().isSet("disabled_worlds")) {
                this.getConfig().set("disabled_worlds", null);
            }
        } else {
            this.getConfig().set("disabled_worlds", this.disabledWorlds);
        }
        if (this.getConfig().get("do_safe_grave_spawn") == null) {
            this.getConfig().set("do_safe_grave_spawn", (Object)true);
            this.saveConfig();
        }
        this.saveConfig();
    }

    public List<String> getDisabledWorlds() {
        return this.disabledWorlds;
    }

    public Updater getUpdater() {
        return this.updater;
    }

    public String getServerVersion() {
        String version = Bukkit.getServer().getClass().getPackage().getName();
        version = version.substring(version.lastIndexOf(46) + 1);
        return version;
    }

    public ConfigManager getCfgm() {
        return this.cfgm;
    }

    public FileConfiguration getConfiguration() {
        return this.config;
    }

    public ChatUtil getChatUtil() {
        return this.chatUtil;
    }

    public ReflexionUtils getReflexionUtils() {
        return this.reflexionUtils;
    }

    public Messages getMsgsUtil() {
        return this.msgsUtil;
    }

    public TokenUtil getTokenUtil() {
        return this.tokenUtil;
    }

    public boolean isUsingFeudal() {
        return Bukkit.getPluginManager().getPlugin("Feudal") != null && Bukkit.getPluginManager().getPlugin("Feudal").isEnabled();
    }

    public boolean isUsingWorldGuard() {
        return Bukkit.getPluginManager().getPlugin("WorldGuard") != null && Bukkit.getPluginManager().getPlugin("WorldGuard").isEnabled();
    }

    public boolean isUsingWorldEdit() {
        return Bukkit.getPluginManager().getPlugin("WorldEdit") != null && Bukkit.getPluginManager().getPlugin("WorldEdit").isEnabled();
    }

    public WorldGuardPlugin getWorldGuard() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (plugin == null || !(plugin instanceof WorldGuardPlugin)) {
            return null;
        }
        return (WorldGuardPlugin)plugin;
    }

    public String getUpdateLink() {
        return "https://www.spigotmc.org/resources/gravy.45288/";
    }

    public boolean isUsingPlaceholderAPI() {
        return Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    }

    public String setPlaceholderAPI(String s, Player target) {
        String sL = s;
        if (this.isUsingPlaceholderAPI()) {
            sL = PlaceholderAPI.setPlaceholders((Player)target, (String)s);
        } else {
            String msg = s;
            sL = msg = msg.replaceAll("%player_name%", target.getName());
        }
        return sL;
    }

    public boolean isUsingVault() {
        return Bukkit.getPluginManager().getPlugin("Vault") != null && Bukkit.getPluginManager().getPlugin("Vault").isEnabled();
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        econ = (Economy)rsp.getProvider();
        return econ != null;
    }

    private boolean setupPermissions() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        perms = (Permission)rsp.getProvider();
        return perms != null;
    }

    private boolean setupChat() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Chat.class);
        try {
            chat = (Chat)rsp.getProvider();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return chat != null;
    }

    public static Economy getEconomy() {
        return econ;
    }

    public static Permission getPermissions() {
        return perms;
    }

    public static Chat getChat() {
        return chat;
    }
}

