/*
 * Decompiled with CFR 0.152.
 */
package me.itsmas.forgemodblocker.util;

import com.google.common.collect.Iterables;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import me.itsmas.forgemodblocker.ForgeModBlocker;
import me.itsmas.forgemodblocker.util.C;
import me.itsmas.forgemodblocker.util.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public final class UtilServer {
    private static final ForgeModBlocker plugin = (ForgeModBlocker)JavaPlugin.getPlugin(ForgeModBlocker.class);

    private UtilServer() {
    }

    static ForgeModBlocker getPlugin() {
        return plugin;
    }

    public static void broadcast(Permission permission, String ... messages) {
        UtilServer.broadcast(permission, true, messages);
    }

    public static void broadcast(Permission permission, boolean prefix, String ... messages) {
        if (prefix) {
            for (int i = 0; i < messages.length; ++i) {
                messages[i] = C.PREFIX + messages[i];
            }
        }
        Bukkit.getOnlinePlayers().stream().filter(player -> Permission.hasPermission((CommandSender)player, permission)).forEach(player -> player.sendMessage(messages));
    }

    public static void registerListener(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, (Plugin)plugin);
    }

    public static void registerOutgoingChannel(String channel) {
        Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)plugin, channel);
    }

    public static void registerIncomingChannel(String channel, PluginMessageListener messageListener) {
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)plugin, channel, messageListener);
    }

    public static void writeBungee(String ... args) {
        assert (args.length > 0) : "Args length must be at least 1";
        Player player = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        if (player == null) {
            return;
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        for (String arg : args) {
            out.writeUTF(arg);
        }
        player.sendPluginMessage((Plugin)plugin, "BungeeCord", out.toByteArray());
    }
}

