/*
 * Decompiled with CFR 0.152.
 */
package me.itsmas.forgemodblocker.update;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import me.itsmas.forgemodblocker.ForgeModBlocker;
import me.itsmas.forgemodblocker.util.C;
import me.itsmas.forgemodblocker.util.Logs;
import me.itsmas.forgemodblocker.util.Permission;
import me.itsmas.forgemodblocker.util.UtilHttp;
import me.itsmas.forgemodblocker.util.UtilServer;
import org.apache.commons.io.FileUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Updater
implements Listener {
    private static final String RESOURCE_VERSIONS = "https://api.spiget.org/v2/resources/ForgeModBlocker/versions?size=1&spiget__ua=ForgeModBlocker&sort=-name";
    private static final String RESOURCE_UPDATES = "https://api.spiget.org/v2/resources/ForgeModBlocker/updates?size=1&spiget__ua=ForgeModBlocker&sort=-date";
    private static final long UPDATE_CHECK_DELAY = 1200L;
    private final long updateCheckInterval;
    private final ForgeModBlocker plugin;
    private Object[] data;
    private final int currentVersion;
    private String joinMessage;
    private final AtomicInteger updateAttempts = new AtomicInteger();
    private final String fileAddress = "https://api.spiget.org/v2/resources/ForgeModBlocker/download";

    public Updater(ForgeModBlocker plugin) {
        this.plugin = plugin;
        this.updateCheckInterval = 1200L * (long)((Integer)plugin.getConfig("update-check-interval", 20L)).intValue();
        this.currentVersion = Integer.parseInt(plugin.getDescription().getVersion().replaceAll("\\.", ""));
        UtilServer.registerListener(this);
        new BukkitRunnable(){

            public void run() {
                if (Updater.this.checkUpdates()) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, 1200L, this.updateCheckInterval);
    }

    private boolean checkUpdates() {
        JsonElement versionElement = UtilHttp.getJsonFromUrl(RESOURCE_VERSIONS);
        JsonElement updateElement = UtilHttp.getJsonFromUrl(RESOURCE_UPDATES);
        if (versionElement == null || updateElement == null) {
            return false;
        }
        JsonArray versionArray = versionElement.getAsJsonArray();
        JsonArray updateArray = updateElement.getAsJsonArray();
        JsonObject latestVersion = versionArray.get(0).getAsJsonObject();
        JsonObject latestUpdate = updateArray.get(0).getAsJsonObject();
        String versionName = latestVersion.get("name").getAsString();
        int version = Integer.parseInt(versionName.replaceAll("\\.", ""));
        if (version > this.currentVersion) {
            String updateTitle = latestUpdate.get("title").getAsString();
            this.data = new Object[]{versionName, updateTitle};
            this.announceUpdate();
            this.attemptDownload();
            return true;
        }
        return false;
    }

    private void announceUpdate() {
        String[] messages = new String[]{"An update is available:", "Version: " + this.data[0] + " (current: " + this.plugin.getDescription().getVersion() + ")", "Title: " + this.data[1]};
        Logs.info(messages);
        this.setJoinMessage(messages);
        UtilServer.broadcast(Permission.UPDATE_NOTIFICATION, false, this.joinMessage);
    }

    private void setJoinMessage(String ... messages) {
        for (int i = 0; i < messages.length; ++i) {
            messages[i] = C.PREFIX + messages[i];
        }
        this.joinMessage = String.join((CharSequence)"\n", messages);
    }

    private void sendJoinMessage(Player player) {
        player.sendMessage(this.joinMessage);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.joinMessage != null && Permission.hasPermission((CommandSender)player, Permission.UPDATE_NOTIFICATION)) {
            this.sendJoinMessage(player);
        }
    }

    private void attemptDownload() {
        block3: {
            Logs.info("Attempting update download");
            UtilServer.broadcast(Permission.UPDATE_NOTIFICATION, "Attempting to download plugin update...");
            File updateDir = new File("plugins" + File.separator + "");
            if (!updateDir.exists()) {
                updateDir.mkdir();
            }
            File pluginFile = new File(updateDir, "ForgeModBlocker.jar");
            try {
                URL updateUrl = new URL("https://api.spiget.org/v2/resources/ForgeModBlocker/download");
                HttpURLConnection connection = (HttpURLConnection)updateUrl.openConnection();
                connection.setRequestProperty("User-Agent", "ForgeModBlocker");
                FileUtils.copyInputStreamToFile((InputStream)connection.getInputStream(), (File)pluginFile);
                Logs.info("Update download successful");
                UtilServer.broadcast(Permission.UPDATE_NOTIFICATION, ChatColor.GREEN + "Update downloaded successfully", ChatColor.GREEN + "Updates will take effect when the server is restarted");
                this.setJoinMessage(ChatColor.GREEN + "A new update was downloaded", ChatColor.GREEN + "Restart the server for it to take effect");
            }
            catch (IOException ex) {
                Logs.severe("Update download failed");
                UtilServer.broadcast(Permission.UPDATE_NOTIFICATION, ChatColor.RED + "Update download failed");
                ex.printStackTrace();
                if (this.updateAttempts.incrementAndGet() > 3) break block3;
                new BukkitRunnable(){

                    public void run() {
                        Updater.this.attemptDownload();
                    }
                }.runTaskLaterAsynchronously((Plugin)this.plugin, 1200L);
            }
        }
    }
}

