/*
 * Decompiled with CFR 0.152.
 */
package me.itsmas.forgemodblocker.mods;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import me.itsmas.forgemodblocker.ForgeModBlocker;
import me.itsmas.forgemodblocker.messaging.JoinListener;
import me.itsmas.forgemodblocker.messaging.MessageListener;
import me.itsmas.forgemodblocker.mods.ModData;
import me.itsmas.forgemodblocker.util.C;
import me.itsmas.forgemodblocker.util.Permission;
import me.itsmas.forgemodblocker.util.UtilServer;
import me.itsmas.forgemodblocker.util.UtilString;
import org.apache.commons.lang3.EnumUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ModManager {
    private final ForgeModBlocker plugin;
    private Mode mode;
    private boolean blockForge;
    private List<String> modList;
    private List<String> disallowedCommands;
    private final Map<Player, ModData> playerData = new HashMap<Player, ModData>();

    public ModManager(ForgeModBlocker plugin) {
        this.plugin = plugin;
        new JoinListener(plugin);
        new MessageListener(plugin);
        this.loadConfigValues();
    }

    public void loadConfigValues() {
        this.loadMode();
        this.blockForge = (Boolean)this.plugin.getConfig("block-forge", false);
        this.modList = (List)this.plugin.getConfig("mod-list", new ArrayList());
        this.disallowedCommands = (List)this.plugin.getConfig("disallowed-mods-commands", Lists.newArrayList((Object[])new String[]{"kick %player% &cIllegal Mods - %disallowed_mods%"}));
        this.disallowedCommands.replaceAll(C::colour);
    }

    private void loadMode() {
        Mode mode = (Mode)EnumUtils.getEnum(Mode.class, (String)((String)this.plugin.getConfig("mode")).toUpperCase());
        this.mode = mode == null ? Mode.BLACKLIST : mode;
    }

    private boolean isDisallowed(String mod) {
        return !this.mode.isAllowed(mod, this.modList);
    }

    public boolean isUsingForge(Player player) {
        return this.playerData.containsKey(player);
    }

    public ModData getModData(Player player) {
        return this.playerData.get(player);
    }

    public void addPlayer(Player player, ModData data) {
        this.playerData.put(player, data);
        this.checkForDisallowed(player, data.getMods());
    }

    private void checkForDisallowed(Player player, Set<String> mods) {
        if (Permission.hasPermission((CommandSender)player, Permission.BYPASS)) {
            return;
        }
        Set disallowed = mods.stream().filter(this::isDisallowed).collect(Collectors.toSet());
        if (disallowed.size() > 0 || mods.size() > 0 && this.blockForge) {
            String modsString = String.join((CharSequence)", ", mods);
            String disallowedString = String.join((CharSequence)", ", disallowed);
            this.sendDisallowedCommand(player, modsString, disallowedString);
        }
    }

    private void sendDisallowedCommand(Player player, String mods, String disallowedMods) {
        this.disallowedCommands.forEach(command -> {
            String[] args = (command = this.formatCommand((String)command, player, mods, disallowedMods)).split(" ");
            if (args[0].equalsIgnoreCase("[bungeekick]")) {
                String reason = UtilString.combine(args, 1);
                UtilServer.writeBungee("KickPlayer", player.getName(), reason);
                return;
            }
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
        });
    }

    private String formatCommand(String command, Player player, String mods, String disallowedMods) {
        return command.replace("%player%", player.getName()).replace("%mods%", mods).replace("%disallowed_mods%", disallowedMods);
    }

    public void removePlayer(Player player) {
        this.playerData.remove(player);
    }

    private static enum Mode {
        WHITELIST((mod, modList) -> modList.contains(mod)),
        BLACKLIST((mod, modList) -> !modList.contains(mod));

        private final BiFunction<String, List<String>, Boolean> function;

        private Mode(BiFunction<String, List<String>, Boolean> function) {
            this.function = function;
        }

        public boolean isAllowed(String mod, List<String> modList) {
            if (mod.equals("FML") || mod.equals("mcp") || mod.equals("Forge")) {
                return true;
            }
            return this.function.apply(mod, modList);
        }
    }
}

