/*
 * Decompiled with CFR 0.152.
 */
package me.itsmas.forgemodblocker;

import me.itsmas.forgemodblocker.command.MainCommand;
import me.itsmas.forgemodblocker.command.ModsCommand;
import me.itsmas.forgemodblocker.metrics.Metrics;
import me.itsmas.forgemodblocker.mods.ModManager;
import me.itsmas.forgemodblocker.placeholder.Placeholders;
import me.itsmas.forgemodblocker.update.Updater;
import me.itsmas.forgemodblocker.util.C;
import me.itsmas.forgemodblocker.util.Message;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class ForgeModBlocker
extends JavaPlugin {
    private ModManager modManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.initConfig();
        boolean placeholderAPI = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        if (placeholderAPI) {
            new Placeholders(this);
        }
        this.getCommand("fmb").setExecutor((CommandExecutor)new MainCommand(this));
        this.getCommand("mods").setExecutor((CommandExecutor)new ModsCommand(this));
        new Metrics(this).addCustomChart(new Metrics.SimplePie("using_placeholderapi", () -> Boolean.toString(placeholderAPI)));
        new Updater(this);
        this.modManager = new ModManager(this);
    }

    public void onDisable() {
        this.destroyTasks();
    }

    public void reload() {
        this.reloadConfig();
        this.initConfig();
        this.getModManager().loadConfigValues();
    }

    private void initConfig() {
        C.setPrefix();
        Message.init(this);
    }

    private void destroyTasks() {
        Bukkit.getScheduler().getPendingTasks().stream().filter(task -> task.getOwner() == this).forEach(BukkitTask::cancel);
    }

    public <T> T getConfig(String path) {
        return this.getConfig(path, null);
    }

    public <T> T getConfig(String path, Object defaultValue) {
        return (T)this.getConfig().get(path, defaultValue);
    }

    public ModManager getModManager() {
        return this.modManager;
    }
}

