/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import me.tom.sparse.spigot.chat.menu.ChatMenuAPI;
import me.tom.sparse.spigot.chat.util.TextUtil;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;

public class Text {
    @Nonnull
    protected List<BaseComponent> components;
    protected int width;

    public Text() {
        this.components = new ArrayList<BaseComponent>();
        this.width = 0;
    }

    public Text(@Nonnull String text) {
        if (text == null) {
            Text.$$$reportNull$$$0(0);
        }
        this.components = new ArrayList<BaseComponent>();
        this.width = 0;
        if (text.contains("\n")) {
            throw new IllegalArgumentException("Text cannot have newline characters");
        }
        Collections.addAll(this.components, TextComponent.fromLegacyText((String)text));
        this.calculateWidth();
    }

    public Text(BaseComponent ... components) {
        if (components == null) {
            Text.$$$reportNull$$$0(1);
        }
        this(Arrays.asList(components));
    }

    public Text(@Nonnull Collection<BaseComponent> components) {
        if (components == null) {
            Text.$$$reportNull$$$0(2);
        }
        this.components = new ArrayList<BaseComponent>();
        this.width = 0;
        this.components.addAll(components);
        if (this.toLegacyText().contains("\n")) {
            throw new IllegalArgumentException("Text cannot have newline characters");
        }
        this.calculateWidth();
    }

    public int getWidth() {
        return this.width;
    }

    public void append(@Nonnull Text other) {
        if (other == null) {
            Text.$$$reportNull$$$0(3);
        }
        this.components.addAll(other.components);
        this.width += other.width;
    }

    public void append(@Nonnull String text) {
        if (text == null) {
            Text.$$$reportNull$$$0(4);
        }
        if (text.contains("\n")) {
            throw new IllegalArgumentException("Text cannot have newline characters");
        }
        Collections.addAll(this.components, TextComponent.fromLegacyText((String)text));
        this.calculateWidth();
    }

    public void append(BaseComponent ... components) {
        if (components == null) {
            Text.$$$reportNull$$$0(5);
        }
        Collections.addAll(this.components, components);
        this.calculateWidth();
    }

    public void expandToWidth(int targetWidth) {
        this.calculateWidth();
        if (this.width >= targetWidth) {
            return;
        }
        this.components.add((BaseComponent)new TextComponent(TextUtil.generateSpaces((int)Math.round((double)(targetWidth - this.width) / 4.0))));
    }

    public void expandToWidthNoExceed(int targetWidth) {
        this.calculateWidth();
        if (this.width >= targetWidth) {
            return;
        }
        this.components.add((BaseComponent)new TextComponent(TextUtil.generateSpaces((int)Math.floor((double)(targetWidth - this.width) / 4.0))));
    }

    public void calculateWidth() {
        this.width = ChatMenuAPI.getWidth(this.toLegacyText());
    }

    @Nonnull
    public String toLegacyText() {
        String string = TextComponent.toLegacyText((BaseComponent[])this.components.toArray(new BaseComponent[this.components.size()]));
        if (string == null) {
            Text.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nonnull
    public List<BaseComponent> getComponents() {
        List<BaseComponent> list = this.components;
        if (list == null) {
            Text.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me/tom/sparse/spigot/chat/util/Text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "me/tom/sparse/spigot/chat/util/Text";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toLegacyText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

