/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class State<V> {
    private Consumer<State<V>> changeCallback;
    @Nonnull
    private Function<V, V> valueFilter;
    @Nullable
    private V current;
    @Nullable
    private V previous;

    public State(@Nullable V current, @Nullable Function<V, V> valueFilter) {
        this.valueFilter = valueFilter == null ? v -> v : valueFilter;
        this.current = this.valueFilter.apply(current);
    }

    public State(@Nullable V current) {
        this(current, v -> v);
    }

    public void setCurrent(@Nullable V newValue) {
        if (Objects.equals(newValue = this.valueFilter.apply(newValue), this.current)) {
            return;
        }
        this.previous = this.current;
        this.current = newValue;
        if (this.changeCallback != null) {
            this.changeCallback.accept(this);
        }
    }

    public Optional<V> getOptionalCurrent() {
        return Optional.ofNullable(this.current);
    }

    public Optional<V> getOptionalPrevious() {
        return Optional.ofNullable(this.previous);
    }

    @Nullable
    public V getCurrent() {
        return this.current;
    }

    @Nullable
    public V getPrevious() {
        return this.previous;
    }

    public void setChangeCallback(@Nonnull Consumer<State<V>> changeCallback) {
        if (changeCallback == null) {
            State.$$$reportNull$$$0(0);
        }
        this.changeCallback = changeCallback;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof State)) {
            return false;
        }
        State state = (State)o;
        return this.current != null ? this.current.equals(state.current) : state.current == null;
    }

    public int hashCode() {
        return this.current != null ? this.current.hashCode() : 0;
    }

    public String toString() {
        return "State{current=" + this.current + ", previous=" + this.previous + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", "changeCallback", "me/tom/sparse/spigot/chat/util/State", "setChangeCallback"));
    }
}

