/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.protocol;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import me.tom.sparse.spigot.chat.protocol.ChatPacketInterceptor;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.entity.Player;

public class PlayerChatIntercept
extends ChannelDuplexHandler {
    public final ChatPacketInterceptor interceptor;
    public final Player player;
    private Queue<BaseComponent[]> messageQueue = new ConcurrentLinkedQueue<BaseComponent[]>();
    private Queue<BaseComponent[]> allowedMessages = null;
    private boolean paused;

    PlayerChatIntercept(ChatPacketInterceptor interceptor, Player player) {
        this.interceptor = interceptor;
        this.player = player;
        while (this.messageQueue.size() < 20) {
            this.messageQueue.add(new BaseComponent[0]);
        }
    }

    public void sendMessage(BaseComponent ... message) {
        if (this.isPaused()) {
            this.allowedMessages.add(message);
        }
        this.player.spigot().sendMessage(message);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        if (this.isPaused()) {
            return;
        }
        this.paused = true;
        System.out.println("Pausing chat for " + this.player.getName());
        this.allowedMessages = new ConcurrentLinkedQueue<BaseComponent[]>();
    }

    public void resume() {
        if (!this.isPaused()) {
            return;
        }
        this.paused = false;
        System.out.println("Resuming chat for " + this.player.getName());
        this.allowedMessages = null;
        ConcurrentLinkedQueue<BaseComponent[]> q = new ConcurrentLinkedQueue<BaseComponent[]>(this.messageQueue);
        for (BaseComponent[] components : q) {
            this.player.spigot().sendMessage(components);
        }
    }

    public void write(ChannelHandlerContext context, Object packet, ChannelPromise promise) throws Exception {
        BaseComponent[] components = this.interceptor.getComponents(packet);
        if (components != null) {
            boolean allowed = this.isAllowed(components);
            boolean paused = this.isPaused();
            if (!paused || !allowed) {
                while (this.messageQueue.size() > 20) {
                    this.messageQueue.remove();
                }
                this.messageQueue.add(components);
            }
            if (paused && !allowed) {
                return;
            }
        }
        super.write(context, packet, promise);
    }

    public boolean isAllowed(BaseComponent[] message) {
        return !this.isPaused() || this.allowedMessages.remove(message);
    }
}

