/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.menu.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tom.sparse.spigot.chat.menu.ChatMenuAPI;
import me.tom.sparse.spigot.chat.menu.IElementContainer;
import me.tom.sparse.spigot.chat.menu.element.Element;
import me.tom.sparse.spigot.chat.util.State;
import me.tom.sparse.spigot.chat.util.Text;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;

public class VerticalSelectorElement
extends Element {
    protected static final int SELECTED_PREFIX_WIDTH = ChatMenuAPI.getWidth("> ");
    @Nonnull
    protected String[] options;
    protected int width;
    @Nonnull
    public final State<Integer> value;
    @Nullable
    protected ChatColor selectedColor;

    public VerticalSelectorElement(int x, int y, int defaultSelected, String ... options) {
        if (options == null) {
            VerticalSelectorElement.$$$reportNull$$$0(0);
        }
        super(x, y);
        this.selectedColor = ChatColor.GREEN;
        for (String option : options) {
            if (option.contains("\n")) {
                throw new IllegalArgumentException("Option cannot contain newline");
            }
            int w = ChatMenuAPI.getWidth(option);
            if (w <= this.width) continue;
            this.width = w;
        }
        this.options = options;
        this.value = new State<Integer>(defaultSelected, this::filter);
    }

    private int filter(int v) {
        return Math.max(Math.min(v, this.options.length), 0);
    }

    public void setSelectedColor(@Nullable ChatColor selectedColor) {
        this.selectedColor = selectedColor;
    }

    @Nullable
    public ChatColor getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedIndex(int value) {
        this.value.setCurrent(value);
    }

    public int getSelectedIndex() {
        return this.value.getOptionalCurrent().orElse(0);
    }

    public String getSelectedOption() {
        int selectedIndex = this.getSelectedIndex();
        return selectedIndex >= 0 && selectedIndex < this.options.length ? this.options[selectedIndex] : null;
    }

    @Override
    public int getWidth() {
        return SELECTED_PREFIX_WIDTH + this.width;
    }

    @Override
    public int getHeight() {
        return this.options.length;
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public List<Text> render(IElementContainer context) {
        String baseCommand = context.getCommand(this);
        ArrayList<Text> result = new ArrayList<Text>();
        for (int i = 0; i < this.options.length; ++i) {
            Text text = new Text();
            BaseComponent[] components = TextComponent.fromLegacyText((String)this.options[i]);
            if (i == this.getSelectedIndex()) {
                text.append("> ");
                if (this.selectedColor != null) {
                    for (BaseComponent component : components) {
                        component.setColor(this.selectedColor);
                    }
                }
            } else {
                text.expandToWidth(SELECTED_PREFIX_WIDTH);
                ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, baseCommand + i);
                for (BaseComponent component : components) {
                    component.setClickEvent(click);
                }
            }
            text.append(components);
            result.add(text);
        }
        return result;
    }

    @Override
    public void edit(@Nonnull IElementContainer container, @Nonnull String[] args) {
        if (container == null) {
            VerticalSelectorElement.$$$reportNull$$$0(1);
        }
        if (args == null) {
            VerticalSelectorElement.$$$reportNull$$$0(2);
        }
        this.value.setCurrent(Integer.parseInt(args[0]));
    }

    @Nonnull
    public List<State<?>> getStates() {
        List<State<?>> list = Collections.singletonList(this.value);
        if (list == null) {
            VerticalSelectorElement.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me/tom/sparse/spigot/chat/menu/element/VerticalSelectorElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "me/tom/sparse/spigot/chat/menu/element/VerticalSelectorElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

