/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.menu.element;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tom.sparse.spigot.chat.menu.ChatMenuAPI;
import me.tom.sparse.spigot.chat.menu.IElementContainer;
import me.tom.sparse.spigot.chat.menu.element.Element;
import me.tom.sparse.spigot.chat.util.Text;

public class TextElement
extends Element {
    protected static final int BORDER_WIDTH = ChatMenuAPI.getWidth("|  |");
    @Nonnull
    protected String[] lines;
    protected int width;
    @Nonnull
    protected TextAlignment alignment;
    protected boolean border;

    public TextElement(@Nonnull String text, int x, int y) {
        if (text == null) {
            TextElement.$$$reportNull$$$0(0);
        }
        super(x, y);
        this.alignment = TextAlignment.LEFT;
        this.lines = text.contains("\n") ? text.split("\n") : new String[]{text};
        for (String line : this.lines) {
            int w = ChatMenuAPI.getWidth(line);
            if (w <= this.width) continue;
            this.width = w;
        }
    }

    public TextElement(int x, int y, String ... text) {
        if (text == null) {
            TextElement.$$$reportNull$$$0(1);
        }
        super(x, y);
        this.alignment = TextAlignment.LEFT;
        for (String line : this.lines = text) {
            if (line.contains("\n")) {
                throw new IllegalArgumentException("Cannot use TextElement line constructor with newline characters.");
            }
            int w = ChatMenuAPI.getWidth(line);
            if (w <= this.width) continue;
            this.width = w;
        }
    }

    public void setText(String text) {
        this.setLines(text.split("\n"));
    }

    public void setLines(String ... lines) {
        if (lines == null) {
            TextElement.$$$reportNull$$$0(2);
        }
        int newWidth = 0;
        for (String line : lines) {
            if (line.contains("\n")) {
                throw new IllegalArgumentException("Cannot use TextElement line constructor with newline characters.");
            }
            int w = ChatMenuAPI.getWidth(line);
            if (w <= newWidth) continue;
            newWidth = w;
        }
        this.lines = lines;
        this.width = newWidth;
    }

    @Nonnull
    public TextElement border() {
        this.border = true;
        TextElement textElement = this;
        if (textElement == null) {
            TextElement.$$$reportNull$$$0(3);
        }
        return textElement;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public boolean isBordered() {
        return this.border;
    }

    @Nonnull
    public TextElement align(@Nonnull TextAlignment alignment) {
        if (alignment == null) {
            TextElement.$$$reportNull$$$0(4);
        }
        this.setAlignment(alignment);
        TextElement textElement = this;
        if (textElement == null) {
            TextElement.$$$reportNull$$$0(5);
        }
        return textElement;
    }

    @Nonnull
    public TextAlignment getAlignment() {
        TextAlignment textAlignment = this.alignment;
        if (textAlignment == null) {
            TextElement.$$$reportNull$$$0(6);
        }
        return textAlignment;
    }

    public void setAlignment(@Nullable TextAlignment alignment) {
        this.alignment = alignment == null ? TextAlignment.LEFT : alignment;
    }

    @Deprecated
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getWidth() {
        return this.border ? this.width + BORDER_WIDTH : this.width;
    }

    @Override
    public int getHeight() {
        return this.border ? this.lines.length + 2 : this.lines.length;
    }

    @Override
    public List<Text> render(IElementContainer context) {
        Text text;
        int middle;
        Text current;
        ArrayList<Text> result = new ArrayList<Text>();
        if (this.alignment == TextAlignment.LEFT) {
            for (String lineString : this.lines) {
                if (this.border) {
                    Text text2 = new Text("| ");
                    text2.append(lineString);
                    text2.expandToWidth(this.width + BORDER_WIDTH / 2);
                    text2.append(" |");
                    result.add(text2);
                    continue;
                }
                result.add(new Text(lineString));
            }
        } else if (this.alignment == TextAlignment.CENTERED) {
            for (String lineString : this.lines) {
                current = new Text(lineString);
                middle = this.width / 2 - current.getWidth() / 2;
                current = new Text();
                current.expandToWidth(middle);
                current.append(lineString);
                if (this.border) {
                    text = new Text("| ");
                    text.append(current);
                    text.expandToWidth(this.width + BORDER_WIDTH / 2);
                    text.append(" |");
                    result.add(text);
                    continue;
                }
                result.add(current);
            }
        } else if (this.alignment == TextAlignment.RIGHT) {
            for (String lineString : this.lines) {
                current = new Text(lineString);
                middle = this.width - current.getWidth();
                current = new Text();
                current.expandToWidth(middle);
                current.append(lineString);
                if (this.border) {
                    text = new Text("| ");
                    text.append(current);
                    text.expandToWidth(this.width + BORDER_WIDTH / 2);
                    text.append(" |");
                    result.add(text);
                    continue;
                }
                result.add(current);
            }
        }
        if (this.border) {
            String border = "+";
            while (ChatMenuAPI.getWidth(border) < this.getWidth()) {
                border = border + "-";
            }
            if (border.length() > 1) {
                border = border.substring(0, border.length() - 1) + "+";
            }
            Text text3 = new Text(border);
            result.add(0, text3);
            result.add(text3);
        }
        return result;
    }

    @Override
    public void edit(@Nonnull IElementContainer container, @Nonnull String[] args) {
        if (container == null) {
            TextElement.$$$reportNull$$$0(7);
        }
        if (args == null) {
            TextElement.$$$reportNull$$$0(8);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me/tom/sparse/spigot/chat/menu/element/TextElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "me/tom/sparse/spigot/chat/menu/element/TextElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "border";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "align";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLines";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "align";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TextAlignment {
        LEFT,
        CENTERED,
        RIGHT;

    }
}

