/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.menu.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tom.sparse.spigot.chat.menu.ChatMenuAPI;
import me.tom.sparse.spigot.chat.menu.IElementContainer;
import me.tom.sparse.spigot.chat.menu.element.Element;
import me.tom.sparse.spigot.chat.util.NumberFormat;
import me.tom.sparse.spigot.chat.util.State;
import me.tom.sparse.spigot.chat.util.Text;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class NumberSliderElement
extends Element {
    public static final int MIN_PRECISION = 0;
    public static final int MAX_PRECISION = 7;
    @Nonnull
    public final State<Integer> value;
    protected int length;
    @Nonnull
    protected ChatColor fullColor = ChatColor.GREEN;
    @Nonnull
    protected ChatColor emptyColor = ChatColor.RED;
    @Nonnull
    protected NumberFormat numberFormat = NumberFormat.PERCENTAGE;
    protected int precision = 6;

    public NumberSliderElement(int x, int y, int length, int value) {
        super(x, y);
        this.length = length;
        this.value = new State<Integer>(value, this::filter);
    }

    public NumberSliderElement(int x, int y, int length, int value, @Nullable NumberFormat format) {
        super(x, y);
        this.length = length;
        this.value = new State<Integer>(value, this::filter);
        this.numberFormat = format == null ? NumberFormat.NONE : format;
    }

    private int filter(int v) {
        return Math.max(Math.min(v, this.length), 0);
    }

    @Nonnull
    public NumberSliderElement colors(@Nonnull ChatColor fullColor, @Nonnull ChatColor emptyColor) {
        if (fullColor == null) {
            NumberSliderElement.$$$reportNull$$$0(0);
        }
        if (emptyColor == null) {
            NumberSliderElement.$$$reportNull$$$0(1);
        }
        this.setFullColor(fullColor);
        this.setEmptyColor(emptyColor);
        NumberSliderElement numberSliderElement = this;
        if (numberSliderElement == null) {
            NumberSliderElement.$$$reportNull$$$0(2);
        }
        return numberSliderElement;
    }

    public NumberSliderElement hideNumber() {
        return this.numberFormat(NumberFormat.NONE);
    }

    public NumberSliderElement numberFormat(@Nullable NumberFormat format) {
        this.setNumberFormat(format);
        return this;
    }

    @Nonnull
    public NumberFormat getNumberFormat() {
        NumberFormat numberFormat = this.numberFormat;
        if (numberFormat == null) {
            NumberSliderElement.$$$reportNull$$$0(3);
        }
        return numberFormat;
    }

    public void setNumberFormat(@Nullable NumberFormat format) {
        this.numberFormat = format == null ? NumberFormat.NONE : format;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        if (precision < 0 || precision > 7) {
            throw new IllegalArgumentException("Precision must be between (inclusive) 0-7");
        }
        this.precision = precision;
    }

    public NumberSliderElement precision(int precision) {
        this.setPrecision(precision);
        return this;
    }

    @Nonnull
    public ChatColor getEmptyColor() {
        ChatColor chatColor = this.emptyColor;
        if (chatColor == null) {
            NumberSliderElement.$$$reportNull$$$0(4);
        }
        return chatColor;
    }

    public void setEmptyColor(@Nullable ChatColor emptyColor) {
        this.emptyColor = emptyColor == null ? ChatColor.RED : emptyColor;
    }

    @Nonnull
    public ChatColor getFullColor() {
        ChatColor chatColor = this.fullColor;
        if (chatColor == null) {
            NumberSliderElement.$$$reportNull$$$0(5);
        }
        return chatColor;
    }

    public void setFullColor(@Nullable ChatColor fullColor) {
        this.fullColor = fullColor == null ? ChatColor.GREEN : fullColor;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length < 0 ? 10 : length;
    }

    public void setWidth(int width) {
        int charWidth = ChatMenuAPI.getCharacterWidth(this.getCharacter());
        this.length = width / charWidth;
    }

    @Nonnull
    public NumberSliderElement width(int width) {
        this.setWidth(width);
        NumberSliderElement numberSliderElement = this;
        if (numberSliderElement == null) {
            NumberSliderElement.$$$reportNull$$$0(6);
        }
        return numberSliderElement;
    }

    public int getValue() {
        return this.value.getOptionalCurrent().orElse(0);
    }

    public void setValue(int value) {
        this.value.setCurrent(value);
    }

    public char getCharacter() {
        return (char)(9608 + this.precision);
    }

    @Override
    public int getWidth() {
        return ChatMenuAPI.getWidth(String.valueOf(this.getCharacter())) * this.length + ChatMenuAPI.getWidth(this.getFormattedNumber());
    }

    private String getFormattedNumber() {
        return " " + this.numberFormat.format(this.getValue(), this.length);
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public List<Text> render(IElementContainer context) {
        String baseCommand = context.getCommand(this);
        ArrayList<BaseComponent> components = new ArrayList<BaseComponent>();
        for (int i = 0; i < this.length; ++i) {
            TextComponent c = new TextComponent(String.valueOf((char)(9608 + this.precision)));
            c.setColor(i <= this.getValue() ? (this.isEnabled() ? this.fullColor : ChatColor.GRAY) : (this.isEnabled() ? this.emptyColor : ChatColor.DARK_GRAY));
            c.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, baseCommand + i));
            components.add((BaseComponent)c);
        }
        components.add((BaseComponent)new TextComponent(this.getFormattedNumber()));
        return Collections.singletonList(new Text(components));
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean onClick(@Nonnull IElementContainer container, @Nonnull Player player) {
        if (container == null) {
            NumberSliderElement.$$$reportNull$$$0(7);
        }
        if (player == null) {
            NumberSliderElement.$$$reportNull$$$0(8);
        }
        return this.isEnabled() && super.onClick(container, player);
    }

    @Override
    public void edit(@Nonnull IElementContainer container, @Nonnull String[] args) {
        if (container == null) {
            NumberSliderElement.$$$reportNull$$$0(9);
        }
        if (args == null) {
            NumberSliderElement.$$$reportNull$$$0(10);
        }
        if (!this.isEnabled()) {
            return;
        }
        this.value.setCurrent(Integer.parseInt(args[0]));
    }

    @Nonnull
    public List<State<?>> getStates() {
        List<State<?>> list = Collections.singletonList(this.value);
        if (list == null) {
            NumberSliderElement.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullColor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyColor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me/tom/sparse/spigot/chat/menu/element/NumberSliderElement";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "me/tom/sparse/spigot/chat/menu/element/NumberSliderElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "colors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumberFormat";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyColor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullColor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "width";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "colors";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onClick";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

