/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.menu.element;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tom.sparse.spigot.chat.menu.CMListener;
import me.tom.sparse.spigot.chat.menu.ChatMenuAPI;
import me.tom.sparse.spigot.chat.menu.IElementContainer;
import me.tom.sparse.spigot.chat.menu.element.Element;
import me.tom.sparse.spigot.chat.util.State;
import me.tom.sparse.spigot.chat.util.Text;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.entity.Player;

public class InputElement
extends Element {
    @Nonnull
    public final State<String> value;
    protected int width;
    private boolean editing;

    public InputElement(int x, int y, int width, @Nonnull String value) {
        if (value == null) {
            InputElement.$$$reportNull$$$0(0);
        }
        super(x, y);
        this.width = width;
        this.value = new State<String>(value);
    }

    @Nullable
    public String getValue() {
        return this.value.getCurrent();
    }

    public void setValue(@Nonnull String value) {
        if (value == null) {
            InputElement.$$$reportNull$$$0(1);
        }
        this.value.setCurrent(value);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    @Nonnull
    public List<Text> render(@Nonnull IElementContainer context) {
        if (context == null) {
            InputElement.$$$reportNull$$$0(2);
        }
        ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, context.getCommand(this));
        String current = this.value.getOptionalCurrent().orElse("");
        boolean tooLong = ChatMenuAPI.getWidth(current) > this.width;
        Text text = new Text(tooLong ? "Too long" : current);
        text.expandToWidth(this.width);
        text.getComponents().forEach(it -> {
            if (tooLong) {
                it.setColor(ChatColor.RED);
            }
            if (this.editing) {
                it.setColor(ChatColor.GRAY);
            }
            it.setUnderlined(Boolean.valueOf(true));
            it.setClickEvent(click);
        });
        List<Text> list = Collections.singletonList(text);
        if (list == null) {
            InputElement.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public boolean onClick(@Nonnull IElementContainer container, @Nonnull Player player) {
        if (container == null) {
            InputElement.$$$reportNull$$$0(4);
        }
        if (player == null) {
            InputElement.$$$reportNull$$$0(5);
        }
        super.onClick(container, player);
        container.getElements().stream().filter(it -> it instanceof InputElement && it != this).map(it -> (InputElement)it).forEach(it -> {
            it.editing = false;
        });
        boolean bl = this.editing = !this.editing;
        if (this.editing) {
            CMListener.expectPlayerChat(player, (p, m) -> {
                if (container == null) {
                    InputElement.$$$reportNull$$$0(9);
                }
                this.editing = false;
                this.setValue((String)m);
                container.refresh();
                return true;
            });
        } else {
            CMListener.cancelExpectation(player);
        }
        return true;
    }

    @Override
    public void edit(@Nonnull IElementContainer container, @Nonnull String[] args) {
        if (container == null) {
            InputElement.$$$reportNull$$$0(6);
        }
        if (args == null) {
            InputElement.$$$reportNull$$$0(7);
        }
    }

    @Nonnull
    public List<State<?>> getStates() {
        List<State<?>> list = Collections.singletonList(this.value);
        if (list == null) {
            InputElement.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me/tom/sparse/spigot/chat/menu/element/InputElement";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "me/tom/sparse/spigot/chat/menu/element/InputElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onClick";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onClick$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

