/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.menu.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import me.tom.sparse.spigot.chat.menu.ChatMenuAPI;
import me.tom.sparse.spigot.chat.menu.IElementContainer;
import me.tom.sparse.spigot.chat.menu.element.Element;
import me.tom.sparse.spigot.chat.util.State;
import me.tom.sparse.spigot.chat.util.Text;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;

public class IncrementalElement
extends Element {
    @Nonnull
    public final State<Integer> value;
    protected int min = Integer.MIN_VALUE;
    protected int max = Integer.MAX_VALUE;

    public IncrementalElement(int x, int y, int value) {
        super(x, y);
        this.value = new State<Integer>(value, this::filter);
    }

    public IncrementalElement(int x, int y, int min, int max, int value) {
        super(x, y);
        this.min = min;
        this.max = max;
        this.value = new State<Integer>(value, this::filter);
    }

    private int filter(int v) {
        return Math.min(Math.max(v, this.min), this.max);
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
        this.value.setCurrent(this.value.getCurrent());
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setValue(int value) {
        this.value.setCurrent(value);
    }

    public int getValue() {
        return this.value.getOptionalCurrent().orElse(0);
    }

    @Override
    public int getWidth() {
        return ChatMenuAPI.getWidth("[-] " + this.value.getCurrent() + " [+]");
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    @Nonnull
    public List<Text> render(@Nonnull IElementContainer context) {
        if (context == null) {
            IncrementalElement.$$$reportNull$$$0(0);
        }
        String baseCommand = context.getCommand(this);
        ArrayList<BaseComponent> components = new ArrayList<BaseComponent>();
        TextComponent decrement = new TextComponent("[-]");
        int current = this.value.getOptionalCurrent().orElse(0);
        if (current - 1 >= this.min) {
            decrement.setColor(ChatColor.RED);
            decrement.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, baseCommand + (current - 1)));
        } else {
            decrement.setColor(ChatColor.DARK_GRAY);
        }
        TextComponent increment = new TextComponent("[+]");
        if (current + 1 <= this.max) {
            increment.setColor(ChatColor.GREEN);
            increment.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, baseCommand + (current + 1)));
        } else {
            increment.setColor(ChatColor.DARK_GRAY);
        }
        TextComponent number = new TextComponent(" " + current + " ");
        components.add((BaseComponent)decrement);
        components.add((BaseComponent)number);
        components.add((BaseComponent)increment);
        List<Text> list = Collections.singletonList(new Text(components));
        if (list == null) {
            IncrementalElement.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public void edit(@Nonnull IElementContainer container, @Nonnull String[] args) {
        if (container == null) {
            IncrementalElement.$$$reportNull$$$0(2);
        }
        if (args == null) {
            IncrementalElement.$$$reportNull$$$0(3);
        }
        this.value.setCurrent(Integer.parseInt(args[0]));
    }

    @Nonnull
    public List<State<?>> getStates() {
        List<State<?>> list = Collections.singletonList(this.value);
        if (list == null) {
            IncrementalElement.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me/tom/sparse/spigot/chat/menu/element/IncrementalElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "me/tom/sparse/spigot/chat/menu/element/IncrementalElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

