/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.menu.element;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import me.tom.sparse.spigot.chat.menu.IElementContainer;
import me.tom.sparse.spigot.chat.menu.element.Element;
import me.tom.sparse.spigot.chat.util.Text;
import org.bukkit.entity.Player;

public class GroupElement
extends Element
implements IElementContainer {
    @Nonnull
    protected final IElementContainer parent;
    @Nonnull
    protected List<Element> elements;

    public GroupElement(@Nonnull IElementContainer parent, int x, int y) {
        if (parent == null) {
            GroupElement.$$$reportNull$$$0(0);
        }
        super(x, y);
        this.parent = parent;
        this.elements = new ArrayList<Element>();
    }

    @Override
    public <T extends Element> T add(@Nonnull T element) {
        if (element == null) {
            GroupElement.$$$reportNull$$$0(1);
        }
        Objects.requireNonNull(element);
        this.elements.add(element);
        this.elements.sort(Comparator.comparingInt(Element::getX));
        return element;
    }

    @Override
    public boolean remove(@Nonnull Element element) {
        if (element == null) {
            GroupElement.$$$reportNull$$$0(2);
        }
        return this.elements.remove(element);
    }

    @Override
    @Nonnull
    public List<Element> getElements() {
        List<Element> list = Collections.unmodifiableList(this.elements);
        if (list == null) {
            GroupElement.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nonnull
    public String getCommand(@Nonnull Element element) {
        int index;
        if (element == null) {
            GroupElement.$$$reportNull$$$0(4);
        }
        if ((index = this.elements.indexOf(element)) == -1) {
            throw new IllegalArgumentException("Unable to interact with the provided element");
        }
        String string = this.parent.getCommand(this) + index + " ";
        if (string == null) {
            GroupElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public int getWidth() {
        Element furthest = this.elements.stream().max(Comparator.comparingInt(Element::getRight)).orElse(null);
        if (furthest == null) {
            return 0;
        }
        return furthest.getRight();
    }

    @Override
    public int getHeight() {
        Element furthest = this.elements.stream().max(Comparator.comparingInt(Element::getBottom)).orElse(null);
        if (furthest == null) {
            return 0;
        }
        return furthest.getBottom();
    }

    @Override
    @Nonnull
    public List<Text> render(@Nonnull IElementContainer context) {
        if (context == null) {
            GroupElement.$$$reportNull$$$0(6);
        }
        if (context != this.parent) {
            throw new IllegalStateException("Attempted to render GroupElement with non-parent context");
        }
        int height = this.getHeight();
        ArrayList<Text> lines = new ArrayList<Text>(height);
        for (int i = 0; i < height; ++i) {
            lines.add(new Text());
        }
        for (Element element : this.elements) {
            if (!element.isVisible()) continue;
            List<Text> elementTexts = element.render(this);
            for (int j = 0; j < elementTexts.size(); ++j) {
                int lineY = element.getY() + j;
                if (lineY < 0 || lineY >= height) continue;
                Text text = (Text)lines.get(lineY);
                text.expandToWidth(element.getX());
                Text toAdd = elementTexts.get(j);
                toAdd.expandToWidth(element.getWidth());
                text.append(toAdd);
            }
        }
        ArrayList<Text> arrayList = lines;
        if (arrayList == null) {
            GroupElement.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    public void edit(@Nonnull IElementContainer container, @Nonnull String[] args) {
        if (container == null) {
            GroupElement.$$$reportNull$$$0(8);
        }
        if (args == null) {
            GroupElement.$$$reportNull$$$0(9);
        }
        int index = Integer.parseInt(args[0]);
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        this.elements.get(index).edit(container, newArgs);
    }

    @Override
    public void openFor(@Nonnull Player player) {
        if (player == null) {
            GroupElement.$$$reportNull$$$0(10);
        }
        this.parent.openFor(player);
    }

    @Override
    public void refresh() {
        this.parent.refresh();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me/tom/sparse/spigot/chat/menu/element/GroupElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "me/tom/sparse/spigot/chat/menu/element/GroupElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "openFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

