/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.menu.element;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tom.sparse.spigot.chat.menu.IElementContainer;
import me.tom.sparse.spigot.chat.util.State;
import me.tom.sparse.spigot.chat.util.Text;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public abstract class Element {
    protected int x;
    protected int y;
    @Nullable
    protected Sound clickSound = Sound.UI_BUTTON_CLICK;
    protected float clickVolume = 0.5f;
    protected float clickPitch = 1.0f;
    private boolean visible = true;

    public Element(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public float getClickPitch() {
        return this.clickPitch;
    }

    public float getClickVolume() {
        return this.clickVolume;
    }

    @Nullable
    public Sound getClickSound() {
        return this.clickSound;
    }

    public void setClickSound(@Nonnull Sound clickSound) {
        if (clickSound == null) {
            Element.$$$reportNull$$$0(0);
        }
        this.clickSound = clickSound;
    }

    public void setClickVolume(float clickVolume) {
        this.clickVolume = clickVolume;
    }

    public void setClickPitch(float clickPitch) {
        this.clickPitch = clickPitch;
    }

    public final int getLeft() {
        return this.getX();
    }

    public final int getRight() {
        return this.getX() + this.getWidth();
    }

    public final int getTop() {
        return this.getY();
    }

    public final int getBottom() {
        return this.getY() + this.getHeight();
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public abstract int getWidth();

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public abstract int getHeight();

    public final boolean overlaps(@Nonnull Element other) {
        if (other == null) {
            Element.$$$reportNull$$$0(1);
        }
        if (other == this) {
            return false;
        }
        int tw = this.getWidth();
        int th = this.getHeight();
        int rw = other.getWidth();
        int rh = other.getHeight();
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = this.getX();
        int ty = this.getY();
        int rx = other.getX();
        int ry = other.getY();
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    public abstract List<Text> render(IElementContainer var1);

    public boolean onClick(@Nonnull IElementContainer container, @Nonnull Player player) {
        if (container == null) {
            Element.$$$reportNull$$$0(2);
        }
        if (player == null) {
            Element.$$$reportNull$$$0(3);
        }
        if (this.clickSound != null) {
            player.playSound(player.getEyeLocation(), this.clickSound, this.clickVolume, this.clickPitch);
        }
        return true;
    }

    public abstract void edit(@Nonnull IElementContainer var1, @Nonnull String[] var2);

    @Nonnull
    public Collection<State<?>> getStates() {
        List<State<?>> list = Collections.emptyList();
        if (list == null) {
            Element.$$$reportNull$$$0(4);
        }
        return list;
    }

    public String toString() {
        return this.getClass().getName() + "{" + "x=" + this.x + ", y=" + this.y + ", visible=" + this.visible + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clickSound";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me/tom/sparse/spigot/chat/menu/element/Element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "me/tom/sparse/spigot/chat/menu/element/Element";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setClickSound";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "overlaps";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onClick";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

