/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.menu.element;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tom.sparse.spigot.chat.menu.ChatMenu;
import me.tom.sparse.spigot.chat.menu.ChatMenuAPI;
import me.tom.sparse.spigot.chat.menu.IElementContainer;
import me.tom.sparse.spigot.chat.menu.element.Element;
import me.tom.sparse.spigot.chat.util.Text;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;

public class ButtonElement
extends Element {
    @Nonnull
    protected String text;
    @Nullable
    protected Function<Player, Boolean> callback;

    public static ButtonElement createCloseButton(int x, int y, @Nonnull String text, @Nonnull ChatMenu menu) {
        if (text == null) {
            ButtonElement.$$$reportNull$$$0(0);
        }
        if (menu == null) {
            ButtonElement.$$$reportNull$$$0(1);
        }
        return new ButtonElement(x, y, text, p -> {
            if (menu == null) {
                ButtonElement.$$$reportNull$$$0(13);
            }
            menu.close((Player)p);
            return false;
        });
    }

    public ButtonElement(int x, int y, @Nonnull String text) {
        if (text == null) {
            ButtonElement.$$$reportNull$$$0(2);
        }
        this(x, y, text, (Function<Player, Boolean>)null);
    }

    public ButtonElement(int x, int y, @Nonnull String text, @Nullable Consumer<Player> callback) {
        if (text == null) {
            ButtonElement.$$$reportNull$$$0(3);
        }
        this(x, y, text, (Player player) -> {
            if (callback != null) {
                callback.accept((Player)player);
            }
            return true;
        });
    }

    public ButtonElement(int x, int y, @Nonnull String text, @Nullable Function<Player, Boolean> callback) {
        if (text == null) {
            ButtonElement.$$$reportNull$$$0(4);
        }
        super(x, y);
        if (text.contains("\n")) {
            throw new IllegalArgumentException("Button text cannot contain newline");
        }
        this.text = text;
        this.callback = callback;
    }

    @Nonnull
    public String getText() {
        String string = this.text;
        if (string == null) {
            ButtonElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setText(@Nonnull String text) {
        if (text == null) {
            ButtonElement.$$$reportNull$$$0(6);
        }
        if (text.contains("\n")) {
            throw new IllegalArgumentException("Button text cannot contain newline");
        }
        this.text = text;
    }

    @Override
    public int getWidth() {
        return ChatMenuAPI.getWidth(this.text);
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    @Nonnull
    public List<Text> render(@Nonnull IElementContainer context) {
        if (context == null) {
            ButtonElement.$$$reportNull$$$0(7);
        }
        String baseCommand = context.getCommand(this);
        BaseComponent[] components = TextComponent.fromLegacyText((String)this.text);
        ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, baseCommand);
        for (BaseComponent component : components) {
            component.setClickEvent(click);
        }
        List<Text> list = Collections.singletonList(new Text(components));
        if (list == null) {
            ButtonElement.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    public boolean onClick(@Nonnull IElementContainer container, @Nonnull Player player) {
        if (container == null) {
            ButtonElement.$$$reportNull$$$0(9);
        }
        if (player == null) {
            ButtonElement.$$$reportNull$$$0(10);
        }
        super.onClick(container, player);
        return this.callback == null ? false : this.callback.apply(player);
    }

    @Override
    public void edit(@Nonnull IElementContainer container, @Nonnull String[] args) {
        if (container == null) {
            ButtonElement.$$$reportNull$$$0(11);
        }
        if (args == null) {
            ButtonElement.$$$reportNull$$$0(12);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "menu";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me/tom/sparse/spigot/chat/menu/element/ButtonElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "me/tom/sparse/spigot/chat/menu/element/ButtonElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCloseButton";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onClick";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createCloseButton$8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

