/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.menu;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tom.sparse.spigot.chat.menu.CMCommand;
import me.tom.sparse.spigot.chat.menu.CMListener;
import me.tom.sparse.spigot.chat.menu.ChatMenu;
import me.tom.sparse.spigot.chat.protocol.ChatPacketInterceptor;
import me.tom.sparse.spigot.chat.protocol.PlayerChatIntercept;
import org.bukkit.entity.Player;
import org.bukkit.map.MapFont;
import org.bukkit.map.MinecraftFont;
import org.bukkit.plugin.Plugin;

public final class ChatMenuAPI {
    private static final Map<String, ChatMenu> MENUS = new ConcurrentHashMap<String, ChatMenu>();
    private static final Map<Player, ChatMenu> OPENED_MENUS = new ConcurrentHashMap<Player, ChatMenu>();
    private static Plugin plugin;
    private static ChatPacketInterceptor interceptor;

    private ChatMenuAPI() {
    }

    @Nullable
    public static ChatMenu getCurrentMenu(@Nonnull Player player) {
        if (player == null) {
            ChatMenuAPI.$$$reportNull$$$0(0);
        }
        return OPENED_MENUS.get(player);
    }

    public static void setCurrentMenu(@Nonnull Player player, @Nullable ChatMenu menu) {
        ChatMenu old;
        if (player == null) {
            ChatMenuAPI.$$$reportNull$$$0(1);
        }
        if ((old = OPENED_MENUS.remove(player)) != null && old != menu) {
            old.onClosed(player);
        }
        if (menu != null) {
            OPENED_MENUS.put(player, menu);
        }
    }

    @Nonnull
    static String registerMenu(ChatMenu menu) {
        String id = ChatMenuAPI.generateIdentifier();
        MENUS.put(id, menu);
        String string = id;
        if (string == null) {
            ChatMenuAPI.$$$reportNull$$$0(2);
        }
        return string;
    }

    static void unregisterMenu(@Nonnull ChatMenu menu) {
        if (menu == null) {
            ChatMenuAPI.$$$reportNull$$$0(3);
        }
        MENUS.values().remove(menu);
    }

    @Nonnull
    private static String generateIdentifier() {
        String result = null;
        while (result == null || MENUS.containsKey(result)) {
            int[] ints = ThreadLocalRandom.current().ints(4L, 9984, 10175).toArray();
            result = new String(ints, 0, ints.length);
        }
        String string = result;
        if (string == null) {
            ChatMenuAPI.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nonnull
    public static PlayerChatIntercept getChatIntercept(@Nonnull Player player) {
        if (player == null) {
            ChatMenuAPI.$$$reportNull$$$0(5);
        }
        PlayerChatIntercept playerChatIntercept = interceptor.getChat(player);
        if (playerChatIntercept == null) {
            ChatMenuAPI.$$$reportNull$$$0(6);
        }
        return playerChatIntercept;
    }

    public static int getWidth(@Nonnull String text) {
        if (text == null) {
            ChatMenuAPI.$$$reportNull$$$0(7);
        }
        if (text.contains("\n")) {
            throw new IllegalArgumentException("Cannot get width of text containing newline");
        }
        int width = 0;
        boolean isBold = false;
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            int charWidth = ChatMenuAPI.getCharacterWidth(c);
            if (c == '\u00a7' && i < chars.length - 1) {
                if ((c = chars[++i]) != 'l' && c != 'L') {
                    if (c == 'r' || c == 'R') {
                        isBold = false;
                    }
                } else {
                    isBold = true;
                }
                charWidth = 0;
            }
            if (isBold && c != ' ' && charWidth > 0) {
                ++width;
            }
            width += charWidth;
        }
        return width;
    }

    public static int getCharacterWidth(char c) {
        if (c >= '\u2588' && c <= '\u258f') {
            return 9615 - c + 2;
        }
        switch (c) {
            case ' ': {
                return 4;
            }
            case '\u2714': {
                return 8;
            }
            case '\u2718': {
                return 7;
            }
        }
        MapFont.CharacterSprite mcChar = MinecraftFont.Font.getChar(c);
        if (mcChar != null) {
            return mcChar.getWidth() + 1;
        }
        return 0;
    }

    static ChatMenu getMenu(String id) {
        return MENUS.get(id);
    }

    public static void init(@Nonnull Plugin plugin) {
        if (plugin == null) {
            ChatMenuAPI.$$$reportNull$$$0(8);
        }
        if (ChatMenuAPI.plugin != null) {
            return;
        }
        ChatMenuAPI.plugin = plugin;
        CMCommand.setLoggerFilter();
        new CMListener(plugin);
        try {
            interceptor = new ChatPacketInterceptor(plugin);
        }
        catch (ReflectiveOperationException e) {
            plugin.getLogger().severe("Unable to create ChatPacketInterceptor! The ChatMenuAPI will not function properly!");
            e.printStackTrace();
        }
    }

    public static void disable() {
        if (plugin == null) {
            return;
        }
        CMCommand.restoreLoggerFilter();
        plugin = null;
        interceptor.disable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me/tom/sparse/spigot/chat/menu/ChatMenuAPI";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "menu";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "me/tom/sparse/spigot/chat/menu/ChatMenuAPI";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "registerMenu";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChatIntercept";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentMenu";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentMenu";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregisterMenu";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getChatIntercept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWidth";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

