/*
 * Decompiled with CFR 0.152.
 */
package me.tom.sparse.spigot.chat.menu;

import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.tom.sparse.spigot.chat.menu.ChatMenuAPI;
import me.tom.sparse.spigot.chat.menu.IElementContainer;
import me.tom.sparse.spigot.chat.menu.element.ButtonElement;
import me.tom.sparse.spigot.chat.menu.element.Element;
import me.tom.sparse.spigot.chat.protocol.PlayerChatIntercept;
import me.tom.sparse.spigot.chat.util.Text;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.entity.Player;

public class ChatMenu
implements IElementContainer {
    @Nonnull
    protected final String id;
    protected boolean registered;
    @Nonnull
    protected List<Element> elements;
    @Nonnull
    protected Set<Player> viewers;
    protected boolean pauseChat;
    protected boolean autoUnregister;

    public ChatMenu(Element ... elements) {
        if (elements == null) {
            ChatMenu.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(elements));
    }

    public ChatMenu(@Nonnull Collection<Element> elements) {
        if (elements == null) {
            ChatMenu.$$$reportNull$$$0(1);
        }
        this.viewers = new ConcurrentSet();
        this.pauseChat = false;
        this.autoUnregister = true;
        this.elements = new ArrayList<Element>();
        this.elements.addAll(elements);
        this.id = ChatMenuAPI.registerMenu(this);
        this.registered = true;
    }

    public void destroy() {
        this.unregister();
        this.elements.clear();
        this.viewers.forEach(this::close);
    }

    public void unregister() {
        if (!this.registered) {
            throw new IllegalStateException("Menu not registered");
        }
        ChatMenuAPI.unregisterMenu(this);
        this.registered = false;
    }

    public void setAutoUnregister(boolean autoUnregister) {
        this.autoUnregister = autoUnregister;
    }

    @Deprecated
    public void addElement(@Nonnull Element element) {
        if (element == null) {
            ChatMenu.$$$reportNull$$$0(2);
        }
        this.add(element);
    }

    @Override
    public <T extends Element> T add(@Nonnull T t) {
        if (t == null) {
            ChatMenu.$$$reportNull$$$0(3);
        }
        Objects.requireNonNull(t);
        this.elements.add(t);
        this.elements.sort(Comparator.comparingInt(Element::getX));
        return t;
    }

    @Override
    public boolean remove(@Nonnull Element element) {
        if (element == null) {
            ChatMenu.$$$reportNull$$$0(4);
        }
        return this.elements.remove(element);
    }

    @Override
    @Nonnull
    public List<Element> getElements() {
        List<Element> list = Collections.unmodifiableList(this.elements);
        if (list == null) {
            ChatMenu.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void edit(@Nonnull Player player, int elementIndex, @Nonnull String[] args) {
        if (player == null) {
            ChatMenu.$$$reportNull$$$0(6);
        }
        if (args == null) {
            ChatMenu.$$$reportNull$$$0(7);
        }
        if (elementIndex < 0 || elementIndex >= this.elements.size()) {
            return;
        }
        Element element = this.elements.get(elementIndex);
        element.edit(this, args);
        if (element.onClick(this, player)) {
            this.refresh();
        }
    }

    @Override
    public void openFor(@Nonnull Player player) {
        if (player == null) {
            ChatMenu.$$$reportNull$$$0(8);
        }
        PlayerChatIntercept chat = ChatMenuAPI.getChatIntercept(player);
        if (this.viewers.add(player) && this.pauseChat) {
            chat.pause();
        }
        for (BaseComponent[] line : this.build()) {
            chat.sendMessage(line);
        }
        ChatMenuAPI.setCurrentMenu(player, this);
    }

    @Override
    public void refresh() {
        this.viewers.removeIf(it -> !it.isOnline());
        for (Player viewer : this.viewers) {
            this.openFor(viewer);
        }
    }

    @Nonnull
    public List<BaseComponent[]> build() {
        Element overlapping = this.findOverlap();
        if (overlapping != null) {
            throw new IllegalStateException("Overlapping element(s)! " + overlapping);
        }
        ArrayList<Text> lines = new ArrayList<Text>(20);
        for (int i = 0; i < 20; ++i) {
            lines.add(new Text());
        }
        for (Element element : this.elements) {
            if (!element.isVisible()) continue;
            List<Text> elementTexts = element.render(this);
            for (int j = 0; j < elementTexts.size(); ++j) {
                int lineY = element.getY() + j;
                if (lineY < 0 || lineY >= 20) continue;
                Text text = (Text)lines.get(lineY);
                text.expandToWidth(element.getX());
                Text toAdd = elementTexts.get(j);
                toAdd.expandToWidth(element.getWidth());
                text.append(toAdd);
            }
        }
        ArrayList<BaseComponent[]> result = new ArrayList<BaseComponent[]>();
        for (Text text : lines) {
            if (text.toLegacyText().contains("\n")) {
                throw new IllegalStateException("Menu contains line with newline character");
            }
            if (text.getWidth() > 320) {
                throw new IllegalStateException("Menu contains line exceeds chat width");
            }
            List<BaseComponent> components = text.getComponents();
            result.add(components.toArray(new BaseComponent[components.size()]));
        }
        ArrayList<BaseComponent[]> arrayList = result;
        if (arrayList == null) {
            ChatMenu.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    public Element findOverlap() {
        return this.elements.stream().filter(Element::isVisible).filter(a -> this.elements.stream().filter(Element::isVisible).anyMatch(b -> a != b && a.overlaps((Element)b))).findFirst().orElse(null);
    }

    public void close(@Nonnull Player player) {
        if (player == null) {
            ChatMenu.$$$reportNull$$$0(10);
        }
        if (this.viewers.remove(player)) {
            ChatMenuAPI.setCurrentMenu(player, null);
            ChatMenuAPI.getChatIntercept(player).resume();
        }
        if (this.viewers.size() == 0 && this.autoUnregister) {
            this.unregister();
        }
    }

    void onClosed(@Nonnull Player player) {
        if (player == null) {
            ChatMenu.$$$reportNull$$$0(11);
        }
        if (this.viewers.remove(player)) {
            ChatMenuAPI.getChatIntercept(player).resume();
        }
    }

    @Nonnull
    public String getCommand() {
        if (!this.isRegistered()) {
            throw new IllegalStateException("Unregistered menus can't be interacted with.");
        }
        String string = "/cmapi " + this.id + " ";
        if (string == null) {
            ChatMenu.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    @Nonnull
    public String getCommand(@Nonnull Element element) {
        if (element == null) {
            ChatMenu.$$$reportNull$$$0(13);
        }
        String string = this.getCommand() + this.elements.indexOf(element) + " ";
        if (string == null) {
            ChatMenu.$$$reportNull$$$0(14);
        }
        return string;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean doesPauseChat() {
        return this.pauseChat;
    }

    @Nonnull
    public ChatMenu pauseChat() {
        this.setPauseChat(true);
        ChatMenu chatMenu = this;
        if (chatMenu == null) {
            ChatMenu.$$$reportNull$$$0(15);
        }
        return chatMenu;
    }

    @Nonnull
    public ChatMenu pauseChat(int x, int y, @Nonnull String text) {
        if (text == null) {
            ChatMenu.$$$reportNull$$$0(16);
        }
        this.setPauseChat(true);
        this.add(ButtonElement.createCloseButton(x, y, text, this));
        ChatMenu chatMenu = this;
        if (chatMenu == null) {
            ChatMenu.$$$reportNull$$$0(17);
        }
        return chatMenu;
    }

    public void setPauseChat(boolean pauseChat) {
        this.pauseChat = pauseChat;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChatMenu)) {
            return false;
        }
        ChatMenu chatMenu = (ChatMenu)o;
        return this.id.equals(chatMenu.id);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @Nonnull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                string = "@Nonnull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me/tom/sparse/spigot/chat/menu/ChatMenu";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "me/tom/sparse/spigot/chat/menu/ChatMenu";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "pauseChat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "openFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "close";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onClosed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "pauseChat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

