/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.util;

import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.util.MathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CommandDelayManager
implements Listener {
    private final Map<String, Integer> commandDelays = new HashMap<String, Integer>();
    private final String dontMove;
    private final String youMoved;
    private final String countdown;
    private final boolean spawnParticles;
    private final Map<UUID, Integer> playertasks = new HashMap<UUID, Integer>();

    public CommandDelayManager(String dontMove, String youMoved, String countdown, boolean spawnParticles) {
        this.dontMove = dontMove;
        this.youMoved = youMoved;
        this.countdown = countdown;
        this.spawnParticles = spawnParticles;
        PrincepsLib.getPluginInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)PrincepsLib.getPluginInstance());
    }

    public void delayCommand(String command, int time) {
        this.commandDelays.put(command, time);
    }

    public boolean isDelayedCommand(String s) {
        for (String s1 : this.commandDelays.keySet()) {
            if (!s.equals(s1)) continue;
            return true;
        }
        return false;
    }

    public int getDelay(String s) {
        return this.commandDelays.get(s);
    }

    public void addPlayerTask(UUID id, int taskid) {
        this.playertasks.put(id, taskid);
    }

    public boolean hasTask(UUID id) {
        return this.playertasks.containsKey(id);
    }

    public void removeTask(UUID id) {
        this.playertasks.remove(id);
    }

    public int getTaskID(UUID id) {
        return this.playertasks.get(id);
    }

    public String getDontMove() {
        return this.dontMove;
    }

    public String getYouMoved() {
        return this.youMoved;
    }

    public String getCountdown() {
        return this.countdown;
    }

    @EventHandler
    public void onCommandPreprocess(final PlayerCommandPreprocessEvent e) {
        final Player p = e.getPlayer();
        String command = e.getMessage();
        if (this.isDelayedCommand(command.toLowerCase())) {
            if (!this.hasTask(p.getUniqueId())) {
                final int delay = this.getDelay(command.toLowerCase());
                e.setCancelled(true);
                p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getDontMove()).replace("%time%", "" + delay));
                int taskid = new BukkitRunnable(){
                    int countdown;
                    int var;
                    {
                        this.countdown = delay * 4;
                        this.var = 0;
                    }

                    public void run() {
                        if (this.countdown == 0) {
                            PrincepsLib.getStuffManager().sendActionBar(p, "");
                            PrincepsLib.getPluginInstance().getServer().dispatchCommand((CommandSender)p, e.getMessage().substring(1));
                            CommandDelayManager.this.removeTask(p.getUniqueId());
                            this.cancel();
                        } else {
                            if (this.countdown % 4 == 0) {
                                PrincepsLib.getStuffManager().sendActionBar(p, ChatColor.translateAlternateColorCodes((char)'&', (String)CommandDelayManager.this.getCountdown()).replace("%countdown%", "" + this.countdown / 4));
                            }
                            if (CommandDelayManager.this.spawnParticles) {
                                Location loc = p.getLocation();
                                List<Location> list = MathUtil.helix(loc, 1.0f, 30, this.var);
                                for (Location location : list) {
                                    PrincepsLib.getStuffManager().spawnPublicParticle(location, Particle.SPELL_WITCH, 2);
                                }
                            }
                            ++this.var;
                            --this.countdown;
                        }
                    }
                }.runTaskTimer((Plugin)PrincepsLib.getPluginInstance(), 0L, 5L).getTaskId();
                this.addPlayerTask(p.getUniqueId(), taskid);
            } else {
                e.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        if ((e.getFrom().getBlockX() != e.getTo().getBlockX() || e.getFrom().getBlockZ() != e.getTo().getBlockZ()) && this.hasTask(p.getUniqueId())) {
            PrincepsLib.getPluginInstance().getServer().getScheduler().cancelTask(this.getTaskID(p.getUniqueId()));
            this.removeTask(p.getUniqueId());
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getYouMoved()));
            PrincepsLib.getStuffManager().sendActionBar(p, "");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent ev) {
        Player p = ev.getPlayer();
        if (this.hasTask(p.getUniqueId())) {
            PrincepsLib.getPluginInstance().getServer().getScheduler().cancelTask(this.getTaskID(p.getUniqueId()));
            this.removeTask(p.getUniqueId());
        }
    }
}

