/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.storage;

import LandLord.landlord.hikari.hikari.HikariConfig;
import LandLord.landlord.hikari.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Datastorage {
    protected final Plugin plugin;
    protected final HikariDataSource ds;

    public Datastorage(Plugin plugin, String hostname, String port, String username, String password, String database) {
        this.plugin = plugin;
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setMaximumPoolSize(10);
        hikariConfig.setJdbcUrl("jdbc:mysql://" + hostname + ":" + port + "/" + database);
        hikariConfig.setUsername(username);
        hikariConfig.setPassword(password);
        hikariConfig.setMaxLifetime(600000L);
        hikariConfig.setIdleTimeout(300000L);
        hikariConfig.setLeakDetectionThreshold(300000L);
        hikariConfig.setConnectionTimeout(10000L);
        this.ds = new HikariDataSource(hikariConfig);
        this.setupDatabase();
    }

    public void close() {
        this.ds.close();
    }

    protected Connection getConnection() {
        try {
            return this.ds.getConnection();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error while trying to pull a new connection: " + e.getMessage());
            return null;
        }
    }

    protected void setupDatabase() {
    }

    public void executeQueryAsync(final String query, final Consumer<ResultSet> consumer) {
        new BukkitRunnable(){

            public void run() {
                Datastorage.this.executeQuery(query, consumer, null);
            }
        }.runTaskAsynchronously(this.plugin);
    }

    public void executeUpdateAsync(final String query, final Object ... args) {
        new BukkitRunnable(){

            public void run() {
                Datastorage.this.executeUpdate(query, args);
            }
        }.runTaskAsynchronously(this.plugin);
    }

    public void executeAsync(final String query, final Object ... args) {
        new BukkitRunnable(){

            public void run() {
                Datastorage.this.execute(query, args);
            }
        }.runTaskAsynchronously(this.plugin);
    }

    public void executeQueryAsync(final String query, final Consumer<ResultSet> consumer, final Object ... args) {
        new BukkitRunnable(){

            public void run() {
                Datastorage.this.executeQuery(query, consumer, args);
            }
        }.runTaskAsynchronously(this.plugin);
    }

    public void executeUpdate(String query, Object ... args) {
        try (Connection con = this.getConnection();
             PreparedStatement st = con.prepareStatement(query);){
            this.evalutePrepStmt(st, args);
            st.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error while executing update for query: " + query + "\nError:" + e.getMessage());
        }
    }

    public void execute(String query, Object ... args) {
        try (Connection con = this.getConnection();
             PreparedStatement st = con.prepareStatement(query);){
            this.evalutePrepStmt(st, args);
            st.execute();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error while executing query: " + query + "\nError:" + e.getMessage());
        }
    }

    public void executeQuery(String query, Consumer<ResultSet> consumer, Object ... args) {
        try (Connection con = this.getConnection();
             PreparedStatement st = con.prepareStatement(query);){
            this.evalutePrepStmt(st, args);
            ResultSet res = st.executeQuery();
            consumer.accept(res);
            res.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error while getting result set for query: " + query + "\nError:" + e.getMessage());
        }
    }

    public Triplet executeQuery(String query, Object ... args) {
        Connection con = this.getConnection();
        try {
            PreparedStatement st = con.prepareStatement(query);
            this.evalutePrepStmt(st, args);
            ResultSet res = st.executeQuery();
            return new Triplet(con, st, res);
        }
        catch (SQLException e) {
            this.plugin.getLogger().warning("Error while getting result set for query: " + query + "\nError:" + e.getMessage());
            return null;
        }
    }

    private void evalutePrepStmt(PreparedStatement st, Object ... args) throws SQLException {
        for (int i = 0; i < args.length; ++i) {
            Object obj = args[i];
            if (obj instanceof String) {
                st.setString(i + 1, (String)obj);
                continue;
            }
            if (obj instanceof Integer) {
                st.setInt(i + 1, (Integer)obj);
                continue;
            }
            if (obj instanceof Double) {
                st.setDouble(i + 1, (Double)obj);
                continue;
            }
            if (obj instanceof Float) {
                st.setFloat(i + 1, ((Float)obj).floatValue());
                continue;
            }
            if (obj instanceof Boolean) {
                st.setBoolean(i + 1, (Boolean)obj);
                continue;
            }
            if (obj instanceof Long) {
                st.setLong(i + 1, (Long)obj);
                continue;
            }
            st.setNull(i + 1, 12);
        }
    }

    public static class Triplet {
        final Connection con;
        final PreparedStatement pr;
        final ResultSet res;

        public Triplet(Connection con, PreparedStatement pr, ResultSet res) {
            this.con = con;
            this.pr = pr;
            this.res = res;
        }

        public ResultSet getResultSet() {
            return this.res;
        }

        public void close() {
            try {
                this.res.close();
                this.pr.close();
                this.con.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

