/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.item;

import biz.princeps.lib.PrincepsLib;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class AbstractItem {
    protected final String name;
    private final boolean breakBlocks;
    private ItemStack stack;
    private boolean glowing;

    public AbstractItem(String name, ItemStack stack, boolean glowing, boolean breakBlocks) {
        this.name = name;
        this.stack = PrincepsLib.crossVersion().addNBTTag(stack, "customItem", "true");
        this.stack = PrincepsLib.crossVersion().addNBTTag(stack, "customItemName", name);
        this.setGlowing(glowing);
        this.breakBlocks = breakBlocks;
    }

    public static boolean isCustomItem(ItemStack stack) {
        return PrincepsLib.crossVersion().hasNBTTag(stack, "customItem");
    }

    public void give(Player p) {
        p.getInventory().addItem(new ItemStack[]{this.stack});
    }

    public abstract void onClick(Action var1, Player var2, Location var3);

    public void setStackSize(int size) {
        this.stack.setAmount(size);
    }

    public void setGlowing(boolean glow) {
        this.glowing = glow;
        if (this.glowing) {
            ItemMeta itemMeta = this.stack.getItemMeta();
            itemMeta.addEnchant(Enchantment.DAMAGE_ALL, 1, false);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            this.stack.setItemMeta(itemMeta);
        } else {
            ItemMeta itemMeta = this.stack.getItemMeta();
            itemMeta.removeEnchant(Enchantment.DAMAGE_ALL);
            itemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            this.stack.setItemMeta(itemMeta);
        }
    }

    public ItemStack getBukkitStack() {
        return this.stack;
    }

    public boolean canBreakBlocks() {
        return this.breakBlocks;
    }
}

