/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.gui.simple;

import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.gui.simple.Action;
import biz.princeps.lib.gui.simple.Icon;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class AbstractGUI
implements InventoryHolder {
    private final Plugin plugin;
    private final Map<Integer, Icon> icons;
    protected String title;
    protected String rawTitle;
    protected AbstractGUI mainMenu;
    protected boolean generateAsync;
    protected Player player;
    protected Inventory inventory;
    private int size;

    public AbstractGUI(Plugin plugin, Player player, int size, String title) {
        this(plugin, player, size, title, null);
    }

    public AbstractGUI(Plugin plugin, Player player, int size, String title, AbstractGUI mainMenu) {
        this.plugin = plugin;
        this.player = player;
        this.icons = new HashMap<Integer, Icon>();
        this.title = this.format(title);
        this.rawTitle = this.format(title);
        this.mainMenu = mainMenu;
        this.size = size;
    }

    private String format(String toFormat) {
        return net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)toFormat);
    }

    public AbstractGUI setIcon(int position, Icon icon) {
        this.icons.remove(position);
        this.icons.put(position, icon);
        if (this.inventory != null) {
            this.inventory.setItem(position, icon.itemStack);
        }
        return this;
    }

    protected void clearIcons() {
        this.icons.clear();
    }

    public Icon getIcon(int position) {
        return this.icons.get(position);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getRawTitle() {
        return this.rawTitle;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void updateIcon(int pos, ItemStack stack) {
        this.icons.get((Object)Integer.valueOf((int)pos)).itemStack = stack;
    }

    public AbstractGUI generateAsync() {
        this.generateAsync = true;
        return this;
    }

    public Inventory getInventory() {
        for (Map.Entry<Integer, Icon> entry : this.icons.entrySet()) {
            this.inventory.setItem(entry.getKey().intValue(), entry.getValue().itemStack);
        }
        this.setBackItem();
        return this.inventory;
    }

    public void refresh() {
        this.inventory.clear();
        this.create();
        this.setBackItem();
    }

    private void setBackItem() {
        if (this.mainMenu != null) {
            this.setIcon(this.size - 5, new Icon(new ItemStack(Material.NETHER_STAR)).setName(ChatColor.GOLD + this.mainMenu.getTitle()).addClickAction(player -> this.mainMenu.display()));
        }
    }

    public CompletableFuture<Inventory> display() {
        this.inventory = this.plugin.getServer().createInventory((InventoryHolder)this, this.size, this.title);
        if (this.generateAsync) {
            final CompletableFuture<Inventory> completableFuture = new CompletableFuture<Inventory>();
            new BukkitRunnable(){

                public void run() {
                    AbstractGUI.this.create();
                    AbstractGUI.this.getInventory();
                    new BukkitRunnable(){

                        public void run() {
                            AbstractGUI.this.player.openInventory(AbstractGUI.this.inventory);
                            completableFuture.complete(AbstractGUI.this.inventory);
                        }
                    }.runTask(AbstractGUI.this.plugin);
                }
            }.runTaskAsynchronously(this.plugin);
            return completableFuture;
        }
        this.create();
        this.getInventory();
        this.player.openInventory(this.inventory);
        return CompletableFuture.completedFuture(this.inventory);
    }

    protected abstract void create();

    public String toString() {
        return "AbstractGUI{size=" + this.size + ", title='" + this.title + '\'' + '}';
    }

    static {
        new InventoryClickListener();
    }

    static class InventoryClickListener
    implements Listener {
        public InventoryClickListener() {
            PrincepsLib.getPluginInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)PrincepsLib.getPluginInstance());
        }

        @EventHandler
        public void onClick(InventoryClickEvent event) {
            if (event.getView().getTopInventory().getHolder() instanceof AbstractGUI) {
                event.setCancelled(true);
                if (event.getWhoClicked() instanceof Player) {
                    Player player = (Player)event.getWhoClicked();
                    ItemStack itemStack = event.getCurrentItem();
                    if (itemStack == null || itemStack.getType() == Material.AIR) {
                        return;
                    }
                    AbstractGUI customHolder = (AbstractGUI)event.getView().getTopInventory().getHolder();
                    Icon icon = customHolder.getIcon(event.getRawSlot());
                    if (icon == null) {
                        return;
                    }
                    for (Action clickAction : icon.getClickActions()) {
                        clickAction.execute(player);
                    }
                }
            }
        }
    }
}

