/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.gui;

import biz.princeps.lib.gui.simple.AbstractGUI;
import biz.princeps.lib.gui.simple.Icon;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MultiPagedGUI
extends AbstractGUI {
    private final List<Icon> icons;
    private final int rowsPerSite;
    private int siteNumber = 0;

    public MultiPagedGUI(Plugin plugin, Player player, int rowsPerSite, String title, List<Icon> icons, AbstractGUI main) {
        super(plugin, player, rowsPerSite * 9 + 9, title, main);
        this.icons = icons;
        this.rowsPerSite = rowsPerSite;
    }

    public MultiPagedGUI(Plugin plugin, Player player, int rowsPerSite, String title) {
        this(plugin, player, rowsPerSite, title, new ArrayList<Icon>(), null);
    }

    public MultiPagedGUI addIcon(Icon icon) {
        this.icons.add(icon);
        return this;
    }

    public void removeIcon(Icon icon) {
        this.icons.remove(icon);
    }

    public List<Icon> filter(String filter) {
        ArrayList<Icon> filtered = new ArrayList<Icon>();
        for (Icon icon : this.icons) {
            if (!icon.itemStack.getItemMeta().getDisplayName().contains(filter)) continue;
            filtered.add(icon);
        }
        return filtered;
    }

    protected void generateStaticIcons() {
    }

    @Override
    protected void create() {
        this.clearIcons();
        this.generateStaticIcons();
        for (int i = 0; i < this.rowsPerSite * 9; ++i) {
            if (i + this.rowsPerSite * this.siteNumber * 9 < this.icons.size()) {
                this.setIcon(i, this.icons.get(i + this.rowsPerSite * this.siteNumber * 9));
                continue;
            }
            this.setIcon(i, new Icon(new ItemStack(Material.AIR)));
        }
        if (this.siteNumber > 0) {
            ItemStack previous = new ItemStack(Material.ARROW);
            this.setIcon(this.rowsPerSite * 9 + 3, new Icon(previous).setName(ChatColor.GREEN + "Previous Page").addClickAction(p -> {
                --this.siteNumber;
                this.refresh();
            }));
        } else {
            this.setIcon(this.rowsPerSite * 9 + 3, new Icon(new ItemStack(Material.AIR)));
        }
        if ((double)(this.siteNumber + 1) < Math.ceil((double)this.icons.size() / (double)(this.rowsPerSite * 9))) {
            ItemStack next = new ItemStack(Material.ARROW);
            this.setIcon(this.rowsPerSite * 9 + 5, new Icon(next).setName(ChatColor.GREEN + "Next Page").addClickAction(p -> {
                ++this.siteNumber;
                this.refresh();
            }));
        } else {
            this.setIcon(this.rowsPerSite * 9 + 5, new Icon(new ItemStack(Material.AIR)));
        }
        if (this.mainMenu != null) {
            this.setIcon(this.rowsPerSite * 9 + 4, new Icon(new ItemStack(Material.NETHER_STAR)).setName(ChatColor.GOLD + this.mainMenu.getTitle()).addClickAction(p -> this.mainMenu.display()));
        }
    }

    public int getRowsPerSite() {
        return this.rowsPerSite;
    }

    public int getSiteNumber() {
        return this.siteNumber;
    }
}

