/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.command;

import biz.princeps.lib.command.Command;
import java.util.Set;
import org.bukkit.command.CommandSender;

public abstract class SubCommand
implements Command {
    private final Set<String> permissions;
    private final String name;
    private final String usage;
    private final Set<String> aliases;

    public SubCommand(String name, String usage, Set<String> permissions, Set<String> aliases) {
        this.name = name;
        this.usage = usage;
        this.aliases = aliases;
        this.permissions = permissions;
    }

    public String toString() {
        return "SubCommand{permissions=" + this.permissions + ", name='" + this.name + '\'' + ", usage='" + this.usage + '\'' + ", aliases=" + this.aliases + '}';
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getUsage() {
        return this.usage;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    @Override
    public boolean hasPermission(CommandSender cs) {
        if (this.permissions.size() == 0) {
            return true;
        }
        for (String permission : this.permissions) {
            if (!cs.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String string) {
        if (this.name.equals(string)) {
            return true;
        }
        for (String alias : this.aliases) {
            if (!alias.equals(string)) continue;
            return true;
        }
        return false;
    }
}

