/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.command;

import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.command.Arguments;
import biz.princeps.lib.command.Command;
import biz.princeps.lib.command.Properties;
import biz.princeps.lib.command.SubCommand;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;

public abstract class MainCommand
extends BukkitCommand
implements Command {
    protected final Map<String, SubCommand> subCommandMap;
    protected final Set<String> permissions;
    private final String noPermissionsCmd = PrincepsLib.getTranslateableStrings().get("Confirmation.accept");

    public MainCommand(String name, String description, String usageMessage, Set<String> perms, String ... aliases) {
        super(name, description, usageMessage, Arrays.asList(aliases));
        this.subCommandMap = new HashMap<String, SubCommand>();
        this.permissions = perms;
        for (Class<?> aClass : this.getClass().getDeclaredClasses()) {
            if (!SubCommand.class.isAssignableFrom(aClass)) continue;
            try {
                Constructor<?> constructor = aClass.getConstructors()[0];
                constructor.setAccessible(true);
                SubCommand subCommand = (SubCommand)constructor.newInstance(this);
                this.addSubcommand(subCommand);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean execute(CommandSender commandSender, String s, String[] strings) {
        if (!this.hasPermission(commandSender)) {
            commandSender.sendMessage(this.noPermissionsCmd.replace("%cmd%", this.getName()));
            return true;
        }
        if (strings.length > 0) {
            for (Map.Entry<String, SubCommand> entry : this.subCommandMap.entrySet()) {
                if (!entry.getKey().equals(strings[0]) && !entry.getValue().getAliases().contains(strings[0])) continue;
                if (!entry.getValue().hasPermission(commandSender)) {
                    commandSender.sendMessage(this.noPermissionsCmd.replace("%cmd%", this.getName() + " " + strings[0]));
                    return true;
                }
                entry.getValue().onCommand(new Properties(commandSender, entry.getValue()), new Arguments(Arrays.copyOfRange(strings, 1, strings.length)));
                return true;
            }
        }
        this.onCommand(new Properties(commandSender, this), new Arguments(strings));
        return true;
    }

    @Override
    public boolean hasPermission(CommandSender cs) {
        if (this.permissions.size() == 0) {
            return true;
        }
        for (String permission : this.permissions) {
            if (!cs.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public void addSubcommand(SubCommand subCommand) {
        if (this.subCommandMap.containsKey(subCommand.getName())) {
            throw new RuntimeException("Subcommand with the name " + subCommand.getName() + " has been already added to " + this.getName());
        }
        this.subCommandMap.put(subCommand.getName(), subCommand);
    }

    public void clearSubcommands() {
        this.subCommandMap.clear();
    }

    public String getCommandString(Class<? extends SubCommand> classy) {
        for (SubCommand value : this.subCommandMap.values()) {
            if (value.getClass() != classy) continue;
            return "/" + this.getName() + " " + value.getName();
        }
        return null;
    }
}

