/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.command;

import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.command.MainCommand;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandManager {
    private final Set<MainCommand> commandSet = new HashSet<MainCommand>();
    private final JavaPlugin plugin = PrincepsLib.getPluginInstance();
    private CommandMap cmdMap;

    public CommandManager() {
        this.initBukkitCommandMap();
    }

    private void initBukkitCommandMap() {
        try {
            Field bukkitCommandMap = this.plugin.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            this.cmdMap = (CommandMap)bukkitCommandMap.get(this.plugin.getServer());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void registerCommand(MainCommand cmd) {
        if (cmd == null) {
            throw new NullPointerException("CMD IS NULL!!");
        }
        this.commandSet.add(cmd);
        if (this.cmdMap == null) {
            this.initBukkitCommandMap();
        }
        this.cmdMap.register(cmd.getName(), (Command)cmd);
        this.plugin.getLogger().info(cmd.getLabel() + " was registered successfully!");
    }

    public MainCommand getCommand(Class<? extends MainCommand> classy) {
        for (MainCommand mainCommand : this.commandSet) {
            if (mainCommand.getClass() != classy) continue;
            return mainCommand;
        }
        return null;
    }
}

