/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.command;

import biz.princeps.lib.exception.ArgumentsOutOfBoundsException;
import biz.princeps.lib.exception.PlayerNotFoundException;
import java.util.Arrays;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Arguments {
    private final String[] strings;

    public Arguments(String[] strings) {
        this.strings = strings;
    }

    public String[] get() {
        return this.strings;
    }

    public String get(int index) {
        this.checkForRange(index);
        return this.strings[index];
    }

    public int getInt(int index) throws ArgumentsOutOfBoundsException, NumberFormatException {
        this.checkForRange(index);
        try {
            return Integer.parseInt(this.strings[index]);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException();
        }
    }

    public double getDouble(int index) throws ArgumentsOutOfBoundsException, NumberFormatException {
        this.checkForRange(index);
        try {
            return Double.parseDouble(this.strings[index]);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException();
        }
    }

    public String[] get(int from, int to) throws ArgumentsOutOfBoundsException {
        this.checkForRange(from);
        this.checkForRange(to);
        if (from > to) {
            throw new RuntimeException("From cant be larger then to! (" + from + " > " + to + ")");
        }
        return Arrays.copyOfRange(this.strings, from, to);
    }

    public Player getPlayer(int index) throws PlayerNotFoundException, ArgumentsOutOfBoundsException {
        this.checkForRange(index);
        Player p = Bukkit.getPlayer((String)this.strings[index]);
        if (p == null) {
            throw new PlayerNotFoundException(this.strings[index]);
        }
        return p;
    }

    private void checkForRange(int index) throws ArgumentsOutOfBoundsException {
        if (index < 0 || index >= this.strings.length) {
            throw new ArgumentsOutOfBoundsException("Invalid CommandArguments access! Accessed: " + index + " length: " + this.strings.length);
        }
    }

    public int size() {
        return this.strings.length;
    }
}

