/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.chat;

import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;

public class MultiPagedMessage {
    private final String command;
    private final int perSite;
    private final List<String> elements;
    private final String previous;
    private final String next;
    private String header;
    private int pointer;

    public MultiPagedMessage(String command, String header, int perSite, List<String> elements, String previous, String next, int pointer) {
        this.command = command;
        this.header = header;
        this.perSite = perSite;
        this.elements = elements;
        this.previous = previous;
        this.next = next;
        this.pointer = pointer;
    }

    public BaseComponent[] create() {
        this.updateTitle();
        ComponentBuilder builder = new ComponentBuilder("");
        builder.append(this.format(this.header));
        builder.append("\n");
        int siteNumberToDisplay = this.pointer;
        for (int i = siteNumberToDisplay * this.perSite; i < (siteNumberToDisplay + 1) * this.perSite; ++i) {
            if (i >= this.elements.size()) continue;
            builder.append(TextComponent.fromLegacyText((String)this.format(this.elements.get(i))));
            builder.append("\n");
        }
        this.pointer = siteNumberToDisplay;
        String cmd = this.command + " ";
        if (siteNumberToDisplay > 0) {
            builder.append(this.format(this.previous)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmd + --this.pointer));
        }
        this.pointer = siteNumberToDisplay;
        if ((double)siteNumberToDisplay < Math.ceil((double)this.elements.size() / (double)this.perSite) - 1.0) {
            builder.append(this.format(this.next)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmd + ++this.pointer));
        }
        return builder.create();
    }

    private String format(String header) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)header);
    }

    private void updateTitle() {
        this.header = this.header.replace("%site%", "" + (this.pointer + 1)).replace("%maxsite%", (int)Math.ceil((double)this.elements.size() / (double)this.perSite) + "");
    }

    public static class Builder {
        private String command;
        private String header;
        private int perSite;
        private List<String> elements;
        private String previous;
        private String next;
        private int pointer;

        public Builder(int perSite, List<String> elements) {
            this.perSite = perSite;
            this.elements = elements;
        }

        public Builder() {
        }

        public Builder setHeaderString(String header) {
            this.header = header;
            return this;
        }

        public Builder setPerSite(int perSite) {
            this.perSite = perSite;
            return this;
        }

        public Builder setElements(List<String> elements) {
            this.elements = elements;
            return this;
        }

        public Builder setPreviousString(String previous) {
            this.previous = previous;
            return this;
        }

        public Builder setNextString(String next) {
            this.next = next;
            return this;
        }

        public Builder setCommand(String command, String[] args) {
            this.command = "/" + command;
            if (args.length == 1) {
                try {
                    this.pointer = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this;
        }

        public MultiPagedMessage build() {
            if (this.command == null || this.header == null || this.perSite < 1 || this.elements == null || this.previous == null || this.next == null) {
                throw new NullPointerException("Cant create a MultiPagedMessage with null parameters!");
            }
            return new MultiPagedMessage(this.command, this.header, this.perSite, this.elements, this.previous, this.next, this.pointer);
        }
    }
}

