/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.chat;

import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;

public class MultiPagedComponentMessage {
    private final String command;
    private final String header;
    private final int perSite;
    private final List<BaseComponent> elements;
    private final String previous;
    private final String next;
    private int pointer;

    public MultiPagedComponentMessage(String command, String header, int perSite, List<BaseComponent> elements, String previous, String next, int pointer) {
        this.command = command;
        this.header = header;
        this.perSite = perSite;
        this.elements = elements;
        this.previous = previous;
        this.next = next;
        this.pointer = pointer;
    }

    public BaseComponent[] create() {
        int siteNumberToDisplay = this.pointer;
        int var = 2;
        if (siteNumberToDisplay > 0 && (double)siteNumberToDisplay < Math.ceil((double)this.elements.size() / (double)this.perSite) - 1.0) {
            var = 3;
        }
        BaseComponent[] components = new BaseComponent[var + this.perSite];
        components[0] = new TextComponent(this.format(this.header) + "\n");
        int count = 1;
        for (int i = siteNumberToDisplay * this.perSite; i < (siteNumberToDisplay + 1) * this.perSite; ++i) {
            if (i >= this.elements.size()) continue;
            TextComponent cp = (TextComponent)this.elements.get(i);
            cp.setText(cp.getText() + "\n");
            components[count] = cp;
            ++count;
        }
        this.pointer = siteNumberToDisplay;
        String cmd = this.command + " ";
        ComponentBuilder builder = new ComponentBuilder("");
        if (siteNumberToDisplay > 0) {
            builder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)this.previous)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmd + --this.pointer));
        }
        this.pointer = siteNumberToDisplay;
        if ((double)siteNumberToDisplay < Math.ceil((double)this.elements.size() / (double)this.perSite) - 1.0) {
            builder.append(ChatColor.translateAlternateColorCodes((char)'&', (String)this.next)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cmd + ++this.pointer));
        }
        components[1 + this.perSite] = builder.create()[1];
        if (var == 3) {
            components[2 + this.perSite] = builder.create()[2];
        }
        return components;
    }

    private String format(String header) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)header);
    }

    public static class Builder {
        private String command;
        private String header;
        private int perSite;
        private List<BaseComponent> elements;
        private String previous;
        private String next;
        private int pointer;

        public Builder(int perSite, List<BaseComponent> elements) {
            this.perSite = perSite;
            this.elements = elements;
        }

        public Builder() {
        }

        public Builder setHeaderString(String header) {
            this.header = header;
            return this;
        }

        public Builder setPerSite(int perSite) {
            this.perSite = perSite;
            return this;
        }

        public Builder setElements(List<BaseComponent> elements) {
            this.elements = elements;
            return this;
        }

        public Builder setPreviousString(String previous) {
            this.previous = previous;
            return this;
        }

        public Builder setNextString(String next) {
            this.next = next;
            return this;
        }

        public Builder setCommand(String command, String[] args) {
            this.command = "/" + command;
            if (args.length == 1) {
                try {
                    this.pointer = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this;
        }

        public MultiPagedComponentMessage build() {
            if (this.command == null || this.header == null || this.perSite < 1 || this.elements == null || this.previous == null || this.next == null) {
                throw new NullPointerException("Cant create a MultiPagedMessage with null parameters!");
            }
            return new MultiPagedComponentMessage(this.command, this.header, this.perSite, this.elements, this.previous, this.next, this.pointer);
        }
    }
}

