/*
 * Decompiled with CFR 0.152.
 */
package biz.princeps.lib.chat;

import biz.princeps.lib.PrincepsLib;
import biz.princeps.lib.gui.simple.Action;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ConfirmationDialog {
    private final String message;
    private final String confirmCommand;
    private final Action onAccept;
    private final Action onDeny;
    private final int acceptTimout;
    private BukkitRunnable runnable;

    public ConfirmationDialog(String message, String confirmCommand, Action onAccept, Action onDeny, int acceptTimout) {
        this.message = message;
        this.confirmCommand = confirmCommand;
        this.onAccept = onAccept;
        this.onDeny = onDeny;
        this.acceptTimout = acceptTimout;
    }

    public void display(final Player p) {
        p.spigot().sendMessage(new ComponentBuilder("").append(TextComponent.fromLegacyText((String)this.message)).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, this.confirmCommand)).create());
        DialogHandler.addPlayer(p.getUniqueId(), this);
        this.runnable = new BukkitRunnable(){

            public void run() {
                if (DialogHandler.contains(p.getUniqueId())) {
                    DialogHandler.removePlayer(p.getUniqueId());
                    if (p.isOnline()) {
                        ConfirmationDialog.this.onDeny.execute(p);
                    }
                }
            }
        };
        this.runnable.runTaskLater((Plugin)PrincepsLib.getPluginInstance(), (long)this.acceptTimout * 20L);
    }

    static {
        new DialogHandler();
    }

    static class DialogHandler
    implements Listener {
        private static final Map<UUID, ConfirmationDialog> openDialogs = new HashMap<UUID, ConfirmationDialog>();

        private DialogHandler() {
            PrincepsLib.getPluginInstance().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)PrincepsLib.getPluginInstance());
        }

        public static synchronized void addPlayer(UUID uniqueId, ConfirmationDialog confirmationDialog) {
            openDialogs.put(uniqueId, confirmationDialog);
        }

        public static synchronized void removePlayer(UUID uniqueId) {
            openDialogs.remove(uniqueId);
        }

        public static synchronized boolean contains(UUID uuid) {
            return openDialogs.containsKey(uuid);
        }

        @EventHandler
        public void onCommand(PlayerCommandPreprocessEvent event) {
            ConfirmationDialog dialog;
            if (DialogHandler.contains(event.getPlayer().getUniqueId()) && (dialog = this.get(event.getPlayer().getUniqueId())).confirmCommand.equals(event.getMessage())) {
                dialog.onAccept.execute(event.getPlayer());
                DialogHandler.removePlayer(event.getPlayer().getUniqueId());
                dialog.runnable.cancel();
            }
        }

        public synchronized ConfirmationDialog get(UUID id) {
            return openDialogs.get(id);
        }
    }
}

